/*------------------------------------------------------------------------------*
 * File Name:Analysis_utils.h 													*
 * Creation: CPY 3/11/03														*
 * Purpose: Origin's basic internal analysis routines							*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 5/24/2004 QA70-6376 REPORT_TABLE_MULTIHEADERS_MORE_WORK					*
 *	YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS							*
 *  Forest 7/29/04 QA70-6067 BASELINE_SECOND_DERIVATIVE_METHOD                  *
 *  Forest 7/30/04 QA70-6077 PEAK_FIRST_DERIVATIVE_METHOD                       *
 *	ML 8/17/2004 QA70-6825 RLOG_QUERY											*
 *	YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION						*
 *	ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING								*
 *	ML 11/11/2004 QA70-6845 CELL_VALUE_LINKING									*
 *  Danice 11/15/04 QA70-7169 v8.0163 TREE_ROW_SHOW_ALTERNATE_COLORS			*
 *	ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS						*
 *	Frank 12/21/2004 NLF_GET_FUNCTION_DETAIL									*
 *  DG 12/29/04 v8.0180 NLF_CLEAN_VISIT_INIFILE									*
 * 	DSC 2/2/05 v8/0189 CENTRALIZE_PATH_PREFIX_CODES								*
 *  DG 2/22/05 v8.0195 RECOGNIZE_FULL_PATH										*
 *	YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION								*
 *	ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC							*
 *	DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL											*
 *	Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH	*
 *	EJP 2005-04-15 v8.0223 CLEAN_ACTIVE_IMPLEMENTATION							*
 *	ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC								*
 *	YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT										*
 *	DSC 8/18/05 AUTOCOMPLETE_XF_CMD_LINE_ARGUMENTS								*
 *	Kevin 08/29/05	ADD_VECTOR_TO_STRING										*
 *	CPY 10/10/05 CENTRALIZED_XF_ARG_QUOTE_HANDLING								*
 *	YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS		*
 *	ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE									*
 *	ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION					*
 *	Frank 11/23/05 ADD_NOISE_AND_SAVE_DATA										*
 *	ML 1/13/2006 XVARIABLEBASE_TO_VC											*
 *	DSC 2/14/06 QA70-7518 ALLOW_SEARCH_XF_BY_KEYWORDS							*
 *  Sandy 07/06/06 GET_COL_ID_WITH_DIFFERENT_ID									*
 *	Sim 08-22-2006 ERR_MSG_SUPPORT_PARAM										*
 *	Sim 08-23-2006 WARNING_MSG_BOX												*
 *  Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION				*
 *	Arvin 9/01/06 ADD_WKS_IS_ALL_COLS_DOUBLE									*
 *	Arvin 9/28/06 ADD_WKS_HAS_TEXT_COL											*
 *	Arvin 9/28/06 ADD_WKS_HAS_COMPLEX_COL										*
 *  Joseph  10/9/06	SEPERATE_DESCIPTION_OR_COMBINE_DESCRIPTION_SECTION			*
 *	Cheney 2006-10-11 GET_DATA_FROM_DR_TO_MAT									*
 *	Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH			*
 *	Cheney 2006-11-22 SHOULD_ALWAYS_USE_INPUT_Y_TO_GET_RESIDUAL					*
 *	Max 11/25/06 RENAME_TO_GET_INPUT_XYRANGE_DATA_SIZE							*
 *	Max 11/25/06 RENAME_TO_GET_INPUT_XYRANGE_NUM								*
 *  Sim 12-08-2006 GET_LARGEST_GAP												*
 *	Sim 04-13-2007 MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF						*
 *	Cheney 2007-5-14 RENAME_FIT_TOOL_CHECK_BOX_NAME								*
 *	YuI 06/12/07 QA70-9913 XYRNAGE_EVEN_SAMPLING_PROPER_SUPPORT					*
 *	Sim 06-19-2007 IMPROVE_WARNING_MESSAGE_POST_FUNCTION						*
 *	Arvin 07/06/07 v8.0654 NEED_USE_THIS_FUNCTION_IN_FITNL						*
 *	Cheney 2007-7-16 SHOULD_GENERATE_X_DATA_UNIFORMLY_SPACED_IN_LOG_SPACE_WHEN_LOG_TYPE
 *	Arvin 07/19/07 USE_STRING_TYPE_LEGEND_DIRECTLY as CP said					*
 *	Cloud 8/30/07 ADD_OPTION_OF_NOISE											*
 *	Folger 09/03/07 CORRECTLY_GET_ORIGIN75_PATH									*
 *	Cheney 2007-9-7 SHOULD_ALLOW_DUP_DATASET_PLOT_FOR_PREVIEW_SO_AS_TO_SAME_WITH_FIT_THINGS
 *	Arvin 10/19/07 USER_SETTED_PERCENTILES_SHOULD_NOT_EFFECT_HISTOGRAM_AND_BOX_CHART_GRAPHS as max said
 *	AW 10/25/07 WRONG_LOCALIZE_MACRO											*
 *	Sim 11-05-2007 IMPROVE_LOCALIZATION_ISSUE									*
 * 	Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
 *	Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO*
 *	Arvin 11/22/07 NEED_RESCALE_FOR_3D_FITTINGS									*
 *	Sim 12-05-2007 REWRITE_WKS_DATA_RANGE_TO_MAT								*
 *	ML 12/17/2007 INITIALIZING_PEAK_POSITIONS_FOR_REPLICAS_FITTING				*
 *	Cloud 12/18/07 TREAT_SIGN_OF_PEAK_AREA										*
 *	Arvin 03/13/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT						*
 *	Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME	*
 *	Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO					*
 *	Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT			*
 *	Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY		*
 *	Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS								*
 *	Cloud 04/10/08 PASS_X_NOMALIZED_STATUS_BY_PARAMETER							*
 *  Iris 4/23/2008 HIDE_INNER_OUTER_LIMITS_FOR_XYFIT_AND_PA						*
 *	CPY 5/5/08 DISABLE_REPLICA_FOR_SURFACE_FIT									*
 *	Folger 08/29/08 QA80-12120 CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE			*
 *	Folger 09/25/08 QA80-12276 SET_SAMPLING_INTERVAL_FOR_YXRANGE_OUTPUT			*
 *	YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER			*
 *	Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP
 *	Folger 11/06/08 QA80-12538 v0.966 CENTRALIZE_CODE_ABOUT_GETTING_GUI_REPLICA_NODE
 *	Folger 11/10/08 QA80-12509 v8.0968 ONLY_SET_PLOT_LABEL_TYPE_IN_PEAK_FIT_DIALOG_EXCLUDE_ROTATION
 *	ML 11/10/2008 QA70-12356 RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES		*
 *	Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
 *	Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
 *	Jasmine 12/04/08 v8.0982b GET_PLOT_COLUMNS									*
 *	Folger 12/18/08 QA80-12642 v8.0988 SUPPORT_MAKE_COLUMN_NAME_WITH_LN_ONLY	*
 *	Folger 01/04/09 QA80-12962 GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
 *	Folger 01/04/09 QA80-12962 MORE_WORK_ON_GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
 *	Kyle 02/24/2009 QA80-13169 CHECK_IF_TWO_RANGE_HAVE_COMMON_RANGE				*
 *	Kyle 02/26/2009 CENTRALIZE_CODE_TO_TRIM_INDEPENDENT							*
 *	Hong 03/09/09 QA80-13243 IMPROVE_AVE_XY_AVOID_MEMORY_LEAKING				*
 *	Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
 *	Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE	*
 *	Kyle 06/01/2009 USE_COMMA_AS_DELIMITER_IN_GOS								*
 *	Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
 *	Kyle 07/20/2009 QA80-13746-P2 SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP
 *	Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
 *	YuI 10/13/09 QA70-14023 OPTION_TO_FORCE_SAMPLING_INTERVAL_RECALCULATION		*
 *	Jasmine 10/19/09 QA81-14478 MASK_DATA_OUSIDE_SD								*
 *	Folger 11/30/09 CENTRALIZE_CODE_ABOUT_FIND_ROOTS							*
 *	Folger 12/11/09 QA81-14831-P2 OPEN_XF_DIALOG_FROM_LT_SUPPRESS_ERROR_WHEN_USER_CANCEL
 *	Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
 *	Kyle 12/16/2009 QA80-14832 QUICK_FIT_EDIT_DIALOG_NEED_FUNC_LIST_WITHOUT_ARGUMENT
 *	Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
 *	Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG		*
 *	Folger 12/29/09 QA81-14832 SET_GET_QUICK_FIT_SOURCE_PLOT_UID				*
 *	Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU				*
 *	Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS			*
 *	Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT						*
 *	Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG						*
 *	Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT							*
 *  Iris 3/16/2010 QA81-10824 TRIM_UNUSEFUL_MISSING_DATA_IN_OUTPUT_COLUMNS		*
 *	Folger 03/31/10 QA81-15258 XF_GETPTS_NEEDED									*
 *	Sophy 4/13/2010 QA81-15308 GET_GRAPHLAYER_OF_INPUTDATA_IN_XF_BODY			*
 *	Folger 08/02/10 ORG-672 INTEG1_SUPPORT_MULTIPLE_XYRANGES					*
 *	Folger 08/27/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
 *	Folger 10/09/2010 ORG-1228-P1 FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL
 *	Folger 10/20/2010 ORG-1286-P1 MORE_TOOLS_FAILED_TO_COPY_SAMPLING_INTERVAL_FROM_INPUT
 *------------------------------------------------------------------------------*/
 
#ifndef _ANALYSIS_UTILS_H
#define _ANALYSIS_UTILS_H

/// Iris 10/29/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
//#define OP_DLG_TOTALLY_NEW_STRUCTURE 
//#define	OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART

#ifdef OP_DLG_TOTALLY_NEW_STRUCTURE

#define OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUI)				trGUI.Plots.GraphInResultSheet.GraphSettings
#define OP_GUI_OUTPUT_TABLES_BRANCH(trGUI)					trGUI.Quantities
#define OP_GUI_BRANCH_OF_PLOTS_CHECKBOX(trGUI)				OP_GUI_OUTPUT_TABLES_BRANCH(trGUI)
#define OP_GUI_BRANCH_OF_STATS_PLOTS_CHECKBOX(trGUI)		OP_GUI_BRANCH_OF_PLOTS_CHECKBOX(trGUI)
#define OP_GUI_FITCURVE_PLOT_CHECKBOX(trGUI)				OP_GUI_BRANCH_OF_PLOTS_CHECKBOX(trGUI).Graph1
#define OP_GUI_BRANCH_OF_RESIDUAL_PLOTS_CHECKBOX(trGUI)		OP_GUI_BRANCH_OF_PLOTS_CHECKBOX(trGUI).Residuals
#define OP_GUI_OUTPUT_TO_SCRIPT_WND_CHECKBOX(trGUI)			trGUI.Output.DumpScriptWindow
#define OP_GUI_OUTPUT_TO_RESULT_LOG_CHECKBOX(trGUI)			trGUI.Output.AddReportToResultsLog
#define OP_GUI_OUTPUT_TO_NOTES_CHECKBOX(trGUI)				trGUI.Output.DumpNotesWindow
#define OP_GUI_FITCURVE_PLOT_SETTINGS(trGUI)				trGUI.Plots.Graph1
#define OP_GUI_FIT_X_DATA_BRANCH(trGUI)						trGUI.XDataType

#else	// !OP_DLG_TOTALLY_NEW_STRUCTURE

#define OP_GUI_GRAPH_ARRANGEMENT_NODE(trGUI)				trGUI.Output.PlotSettings
#define OP_GUI_OUTPUT_TABLES_BRANCH(trGUI)					trGUI.Output.Create
#define OP_GUI_BRANCH_OF_STATS_PLOTS_CHECKBOX(trGUI)		trGUI.Plots
#define OP_GUI_FITCURVE_PLOT_CHECKBOX(trGUI)				trGUI.Graph1
#define OP_GUI_BRANCH_OF_RESIDUAL_PLOTS_CHECKBOX(trGUI)		trGUI.Residuals
#define OP_GUI_OUTPUT_TO_SCRIPT_WND_CHECKBOX(trGUI)			trGUI.Output.Report.DumpScriptWindow
#define OP_GUI_OUTPUT_TO_RESULT_LOG_CHECKBOX(trGUI)			trGUI.Output.Report.AddReportToResultsLog
#define OP_GUI_OUTPUT_TO_NOTES_CHECKBOX(trGUI)				trGUI.Output.Report.DumpNotesWindow
#define OP_GUI_FITCURVE_PLOT_SETTINGS(trGUI)				trGUI.Graph1
#define OP_GUI_FIT_X_DATA_BRANCH(trGUI)						trGUI.Graph1.XDataType

#endif // OP_DLG_TOTALLY_NEW_STRUCTURE
///end OP_DLG_NEW_STRUCTURE

///Sophy 11/2/2009 QA81-14546 OP_DLG_NEW_STRUCTURE
#ifdef	OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART

//These macros can only be use in Class member functions
#define	OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI)			trGUI.Data
#define	OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI)				trGUI.Residual
#define	OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI)				trGUI.FindXY
#define	OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(trGUI)			trGUI.PartialCurves
#define	OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(trGUI)		trGUI.SubtractedData
#define	OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(trGUI)			trGUI.BaselineData
#define	OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI)		trGUI.PeakCharacter
#define OP_GUI_CALIBRATION_BRANCH(trGUI)					OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI).Calibration
#define OP_GUI_RESIDUAL_ANALYSIS_BRANCH(trGUI)				trGUI.Residual.ResAnalysis

//These macros can only be use in global/event functions
#define	GLOBAL_OUTPUT_FITTEDCURVE_BRANCH(tr)				tr.Data
#define	GLOABL_OUTPUT_RESIDUAL_BRANCH(tr)					tr.Residual
#define	GLOABL_OUTPUT_FINDXY_BRANCH(tr)						tr.FindXY

#else // !OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART

//These macros can only be use in Class member functions
#define	OP_GUI_OUTPUT_TO_FITTEDCURVE_BRANCH(trGUI)			GetOutputNode(trGUI).Data
#define	OP_GUI_OUTPUT_TO_RESIDUAL_BRANCH(trGUI)				GetOutputNode(trGUI).Residual
#define	OP_GUI_OUTPUT_TO_FINDXY_BRANCH(trGUI)				GetOutputNode(trGUI).FindXY
#define	OP_GUI_OUTPUT_TO_PARTIALCURVE_BRANCH(trGUI)			GetOutputNode(trGUI).PartialCurves
#define	OP_GUI_OUTPUT_TO_SUBTRACTEDDATA_BRANCH(trGUI)		GetOutputNode(trGUI).SubtractedData
#define	OP_GUI_OUTPUT_TO_BASELINEDATA_BRANCH(trGUI)			GetOutputNode(trGUI).BaselineData
#define	OP_GUI_OUTPUT_TO_PEAKCHARACTER_BRANCH(trGUI)		GetOutputNode(trGUI).PeakCharacter
#define OP_GUI_CALIBRATION_BRANCH(trGUI)					trGUI.Calibration
#define OP_GUI_RESIDUAL_ANALYSIS_BRANCH(trGUI)				trGUI.ResAnalysis

//These macros can only be use in global/event functions
#define	GLOBAL_OUTPUT_FITTEDCURVE_BRANCH(tr)				tr.Output.Data
#define	GLOABL_OUTPUT_RESIDUAL_BRANCH(tr)					tr.Output.Residual
#define	GLOABL_OUTPUT_FINDXY_BRANCH(tr)						tr.Output.FindXY

#endif	//OP_DLG_TOTALLY_NEW_STRUCTURE_OUTPUT_PART
///end OP_DLG_NEW_STRUCTURE

//Frank 12/14/04 QA70-6086 FO_CODE_CLEAN_UP
//Commetnts last updated by Frank on 1/06/05
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:STR_CURRENT_SHARE_STATE_ATTRIB
*/
#define STR_CURRENT_SHARE_STATE_ATTRIB			"ShareSign"
///Frank 	04/05/05 GUI_ADVANCED_SETTING_FROM_FIRE
#define STR_GUI_THEME_FILE_ATTRIB		"AdvanThemeFile"	///Frank 4/5/05	
///End GUI_ADVANCED_SETTING_FROM_FIRE

/// Iris 01/08/2007 v8.0538 NEED_GET_ANALYSIS_NAME_FOR_REPORT_TREE_BROWSER
/// YuI 09/22/08 QA70-12243 EXTENSION_TO_DOC_E_LABTALK_COMMAND
// moved to OC_Const.h
//	#define	STR_ANALYSIS_ATTRIB				"AnalysisName"
/// end EXTENSION_TO_DOC_E_LABTALK_COMMAND
///end NEED_GET_ANALYSIS_NAME_FOR_REPORT_TREE_BROWSER
///////////////////////////////////////////////////////////////////////////////////
//					Error Messages
///////////////////////////////////////////////////////////////////////////////////
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ERROR_TITLE
*/
/// AW 10/25/07 WRONG_LOCALIZE_MACRO
/*
#define	ERROR_TITLE			"Attention!"
#define CON_LEV_ERROR_MSG	"Error: Confidence level(s) must be a space seperated list of numberic values > 0 AND < 100!"
#define CON_LEV_VAL_ERROR_MSG	"Error: Confidence level must be a numeric value > 0 and < 100!"
#define ELLIPSE_CON_LEV_VAL_ERROR_MSG	"Error: Confidence level must be a numeric value >= 5 and <= 99.9!"
#define PERSENTILE_ERROR_MSG	"Error: Percentile list must be a space seperated list of numeric value > 0 and < 100!"
#define SIG_LEV_ERROR_MSG	"Error: Significance level must be a single numeric value > 0 and < 1!"
#define SAMP_SIZE_ERROR_MSG	"Error: Sample size(s) must be a space seperated list of positive integers larger than 1!"
#define SAMP_SIZE_TOO_FEW_MSG	"Error: Hypothetical sample size should be greater than 1!"
#define POW_VAL_ERROR_MSG	"Error: Power value(s) must be a space seperated list of numeric values > 0  and < 1!"
#define CHI_SQR_HYPOT_VAL_ERROR_MSG	"Error: Hypothetical variance value should not be less than 0!"
#define FREQ_MAX_STEP_ERROR_MSG	"Error: Step size must be greater than 0 and less than (maximun - minimum)/2!"
#define FREQ_INTERVAL_NUM_ERROR_MSG	"Error: Number of intervals must be a positive integer!"
#define TAIL_ERROR_MSG	"Error: Error tail setting!"
#define DATA_TOO_FEW_MSG	"Error: Too few data points!"
#define ALL_ELEMENT_EQUAL_MSG	"Error: All elements should not be equal!"
#define UNKNOWN_ERROR_MSG	"Error: Error code: "
#define CONF_UNKN_ERROR_MSG	"Error: Unknown Error for Confidence computation! Error code: "
#define PARA_TYPE_ERROR_MSG	"Error: paratype must only be 0 or 1!"
#define DATA_TOO_MORE_MSG	"Error: Too more data points!"
#define DATA_GET_ERROR_MSG	"Error: Error in getting data!"
#define SD_ERROR_MSG	"Error: SD should be greater than 0"
#define HYPOT_SAMP_ERROR_MSG	"Error: Error: Sample size(s) must be positive integers larger than 1!"
#define HYPOT_POW_ERROR_MSG	"Error: Power value(s) must be numeric values > 0  and < 1!"
#define POW_TOO_FEW_MSG	"Error: At least 1 hypothetical power!"
#define INVALID_MATRIXOBJECT "Error: MatrixObject is invalid!"
#define POW_TOO_SMALL_MSG	"Error: Power value(s) must be larger than "
#define NULL_HYPOT_ERROR_MSG	"Error: Result can not be solved under the null hypothesis"
#define DATA_LENGTH_ERROR_MSG	"Error: x and y must have the same length!"
#define NO_DATA_SELEC_MSG	"Error: No selected data!"
#define MISSING_IN_DATA_MSG	"Warning: There are %d missing/masked value(s) in input data"
#define ONE_SAMPLE_TTEST_COLUMN_NUM_ERR_MSG	"Error: Please select one column!"
#define TWO_SAMPLE_TTEST_COLUMN_NUM_ERR_MSG	"Error: Please select two columns!"
#define TWO_SAMPLE_TTEST_GROUP_NUM_ERR_MSG	"Error: Group range should has only two levels."
#define	SA_TIME_CENSOR_DIFF_SIZE_MSG_	"Error: The Time and Censor data range must have the same number of data points."
#define SA_TIME_GROUP_DIFF_SIZE_MSG	"Error: The Group data range must have the same number of data points as Time and Censor data range. "
#define SA_TIME_COVAR_DIFF_SIZE_MSG	"Error: Each Covariate dataset must have the same number of data points as Time and Censor data range."
#define	NO_DATA_MSG	"Error: You must have data to run an analysis"
#define NO_CENSORING_MSG	"Please choose at least one censoring value for the Censoring Values"
#define	NOT_VALID_CENSORING_MSG	"One or more censoring value can not be find in censor range"

#define ERR_NEED_SPACE_AFTER_DASH "Error: no space is allowed after dash"
#define ERR_VAL_ALREADY_SPECIFIED "Error: the value for variable -%s is already specified as %s"
#define ERR_NO_ARG_BY_THAT_NAME "Error: cannot find any variable corresponding to specified key -%s"
#define ERR_KEY_IS_MISSING_VAL "Error: variable -%s is missing a value"
#define ERR_VAL_IS_MISSING_KEY "Error: value %s is missing a variable name"
#define ERR_CANNOT_LESS_ZERO 		"Error: %s must not be less than 0.0"
#define ERR_CANNOT_LESS_EQUAL_ZERO 	"Error: %s must not be less than or equal 0.0"
#define CORRE_OUT_RANGE_MSG "Error: the correlation is out the range of [-1,1]"
#define TREATMENT_ERROR_MSG	"Error: # of treatment value must be interger greater than 1"
#define	WKS_INVALID_MSG	"Error: Invalid source worksheet!"
#define ERROR_COND_MSG	"Error: Invalid conditional expression "
#define WARNING_SAME_WKS	"Warning: Input and Output worksheet can not be the same if extracting data by group!"
#define ERR_BIG_EQUAL_LESS_EQUAL "Error: %s value must be >= 0 and <=1!"
#define ERR_BIG_LESS_EQUAL "Error: %s value must be >0 and <=1000000!"
#define WAR_INVALID "Warning: %s value is an invalid value and it must be less than 1!"
#define PERCENTILE_ERROR_MSG	"Error: Value(s) must be a space seperated list of numberic values >= 0 AND <= 100!"

#define WAR_VECTOR_SIZE_DIFFERENCE "Warning: input vectors have difference size, append by zeros!"
#define DATARANGE_SETDATA_FAILED_MSG "DataRange::SetData failed."
#define INTERNAL_CASTING_ERROR_MSG "Internal casting error!"
#define GET_INPUT_FAIL_MSG "Get input data fail!"
#define NO_TREE_NODE_ERR_MSG "err:no temp tree node!"
#define CONVERT_FDF_TREE_FAIL_MSG "Fail to convert FDF to tree!"
#define NLFIT_SETDATA_FAILED_MSG "SetData() failed!"
#define INVALID_PARAMATER_MSG "Invalid paramater setting!"
#define FITTING_FAILED_MSG "Cannot perform fitting, 0 returned!"
#define WARN_FIT_FAIL_MSG "fail to Fit::GetParameterResults!"
#define COMPILE_NLFITTING_FAILED_MSG "failed to compile NLFitting.c!"
#define INVALID_DATAPLOT_MSG "Invalid dataplot!"
#define BIN_COUNT_NOT_MATCH_MSG "Error, bin and count should match!"
#define COMPILE_MERGEGRAPHSDLG_FAILED_MSG "failed to compile MergeGraphsDlg.c!"
#define INVALID_SENDER_OBJECT_MSG "Invalid event sender object!"
#define INVALID_REGION_OBJECT_MSG "Error: not a valid region object!"
#define INVALID_MATRIX_LAYER_MSG "Error: invalid matrix layer!"
#define WARN_NOTHING_SELECTED "Error: nothing selected!"
#define DERIVATIVE_FAILED_MSG "Derivative failed."
#define INTEGRATE_FAILED_MSG "Integrate failed."
#define DATARANGE_GETDATA_FAILED_MSG "DataRange::GetData failed."
#define NO_VALID_DATA_MSG "Error: no valid data!"
#define INVALID_SHRINK_COE_MSG "Error: invalid shrink coefficient!"
#define FAIL_SHRINK_MATRIX_MSG "Error: fail to shrink matrix!"
#define FAIL_SHOW_INFO_MSG	"Error: failed to show Data Info window!"
#define INVALID_FUNCTION_OR_DATAPLOT	"Error: invalid X-Function, or invalid DataPlot to assign X-Function!"
#define WARN_FEW_COLROW_NUMBER "Warning: too few col or row numbers!"
#define FAIL_COPY_DATA_ERR_MSG	"Error: fail to copy data from worksheet to matrix!"
#define RETRIEVE_DATA_ERR_MSG	"Error: failed to retrieve input data!"
#define NOT_REGULAR_ERR_MSG	"Error: x-y are not regular, try random conversion methods!"
#define NOT_SPARSE_ERR_MSG	"Error: x-y are not sparse, try random conversion methods!"
#define FAILED_GET_XYZ_MSG	"Error: failed to get XYZ data!"
#define FAILED_CREATE_GRIDDING_MSG	"Error: failed to create XY gridding!"
#define INVALID_DATA_TYPE "Error: the internal data type is not complex!"
 */
#define	ERROR_TITLE			_L("Attention!")
///Echo 10/26/04 NOT_USED_MACRO
///macros are used in old mechanism to report error. They should be moved to oErrMsg.dll
/* 
#define CON_LEV_VAL_ERROR_MSG	_L("Error: Confidence level must be a numeric value > 0 and < 100!")
#define PERCENTILE_ERROR_MSG	_L("Error: Value(s) must be a space seperated list of numberic values >= 0 AND <= 100!")
#define ELLIPSE_CON_LEV_VAL_ERROR_MSG	_L("Error: Confidence level must be a numeric value >= 5 and <= 99.9!")
#define CON_LEV_ERROR_MSG	_L("Error: Confidence level(s) must be a space seperated list of numberic values > 0 AND < 100!")
#define PERSENTILE_ERROR_MSG	_L("Error: Percentile list must be a space seperated list of numeric value > 0 and < 100!")
#define SIG_LEV_ERROR_MSG	_L("Error: Significance level must be a single numeric value > 0 and < 1!")
#define SAMP_SIZE_ERROR_MSG	_L("Error: Sample size(s) must be a space seperated list of positive integers larger than 1!")
#define SAMP_SIZE_TOO_FEW_MSG	_L("Error: Hypothetical sample size should be greater than 1!")
#define POW_VAL_ERROR_MSG	_L("Error: Power value(s) must be a space seperated list of numeric values > 0  and < 1!" )
#define CHI_SQR_HYPOT_VAL_ERROR_MSG	_L("Error: Hypothetical variance value should not be less than 0!")
#define FREQ_MAX_STEP_ERROR_MSG	_L("Error: Step size must be greater than 0 and less than (maximun - minimum)/2!")
#define FREQ_INTERVAL_NUM_ERROR_MSG	_L("Error: Number of intervals must be a positive integer!")
#define TAIL_ERROR_MSG	_L("Error: Error tail setting!")
#define DATA_TOO_FEW_MSG	_L("Error: Too few data points!")
#define ALL_ELEMENT_EQUAL_MSG	_L("Error: All elements should not be equal!")
#define UNKNOWN_ERROR_MSG	_L("Error: Error code: ")
#define CONF_UNKN_ERROR_MSG	_L("Error: Unknown Error for Confidence computation! Error code: ")
#define PARA_TYPE_ERROR_MSG	_L("Error: paratype must only be 0 or 1!")
#define DATA_TOO_MORE_MSG	_L("Error: Too more data points!")
#define DATA_GET_ERROR_MSG	_L("Error: Error in getting data!")
#define SD_ERROR_MSG	_L("Error: SD should be greater than 0")
#define HYPOT_SAMP_ERROR_MSG	_L("Error: Error: Sample size(s) must be positive integers larger than 1!")
#define HYPOT_POW_ERROR_MSG	_L("Error: Power value(s) must be numeric values > 0  and < 1!")
#define POW_TOO_FEW_MSG	_L("Error: At least 1 hypothetical power!")
#define INVALID_MATRIXOBJECT _L("Error: MatrixObject is invalid!")
#define POW_TOO_SMALL_MSG	_L("Error: Power value(s) must be larger than ")
#define NULL_HYPOT_ERROR_MSG	_L("Error: Result can not be solved under the null hypothesis")
#define DATA_LENGTH_ERROR_MSG	_L("Error: x and y must have the same length!")
#define NO_DATA_SELEC_MSG	_L("Error: No selected data!")
#define MISSING_IN_DATA_MSG	_L("Warning: There are %d missing/masked value(s) in input data")
#define ONE_SAMPLE_TTEST_COLUMN_NUM_ERR_MSG	_L("Error: Please select one column!")
#define TWO_SAMPLE_TTEST_COLUMN_NUM_ERR_MSG	_L("Error: Please select two columns!")
#define TWO_SAMPLE_TTEST_GROUP_NUM_ERR_MSG	_L("Error: Group range should has only two levels.")
#define	SA_TIME_CENSOR_DIFF_SIZE_MSG_	_L("Error: The Time and Censor data range must have the same number of data points.")
#define SA_TIME_GROUP_DIFF_SIZE_MSG	_L("Error: The Group data range must have the same number of data points as Time and Censor data range. " )
#define SA_TIME_COVAR_DIFF_SIZE_MSG	_L("Error: Each Covariate dataset must have the same number of data points as Time and Censor data range.")
#define	NO_DATA_MSG	_L("Error: You must have data to run an analysis")
#define NO_CENSORING_MSG	_L("Please choose at least one censoring value for the Censoring Values")
#define	NOT_VALID_CENSORING_MSG	_L("One or more censoring value can not be find in censor range")

#define ERR_NEED_SPACE_AFTER_DASH _L("Error: no space is allowed after dash")
#define ERR_VAL_ALREADY_SPECIFIED _L("Error: the value for variable -%s is already specified as %s")
#define ERR_NO_ARG_BY_THAT_NAME _L("Error: cannot find any variable corresponding to specified key -%s")
#define ERR_KEY_IS_MISSING_VAL _L("Error: variable -%s is missing a value")
#define ERR_VAL_IS_MISSING_KEY _L("Error: value %s is missing a variable name")
#define ERR_CANNOT_LESS_ZERO 		_L("Error: %s must not be less than 0.0")
#define ERR_CANNOT_LESS_EQUAL_ZERO 	_L("Error: %s must not be less than or equal 0.0")
#define CORRE_OUT_RANGE_MSG _L("Error: the correlation is out the range of [-1,1]")
#define TREATMENT_ERROR_MSG	_L("Error: # of treatment value must be interger greater than 1")
#define	WKS_INVALID_MSG	_L("Error: Invalid source worksheet!")
#define ERROR_COND_MSG	_L("Error: Invalid conditional expression ")
#define WARNING_SAME_WKS	_L("Warning: Input and Output worksheet can not be the same if extracting data by group!")
#define ERR_BIG_EQUAL_LESS_EQUAL _L("Error: %s value must be >= 0 and <=1!")
#define ERR_BIG_LESS_EQUAL _L("Error: %s value must be >0 and <=1000000!")
#define WAR_INVALID _L("Warning: %s value is an invalid value and it must be less than 1!")

#define WAR_VECTOR_SIZE_DIFFERENCE _L("Warning: input vectors have difference size, append by zeros!")
#define DATARANGE_SETDATA_FAILED_MSG _L("DataRange::SetData failed.")
#define INTERNAL_CASTING_ERROR_MSG _L("Internal casting error!")
#define GET_INPUT_FAIL_MSG _L("Get input data fail!")
#define NO_TREE_NODE_ERR_MSG _L("err:no temp tree node!")
#define CONVERT_FDF_TREE_FAIL_MSG _L("Fail to convert FDF to tree!")
#define NLFIT_SETDATA_FAILED_MSG _L("SetData() failed!")
#define INVALID_PARAMATER_MSG _L("Invalid paramater setting!")
#define FITTING_FAILED_MSG _L("Cannot perform fitting, 0 returned!")
#define WARN_FIT_FAIL_MSG _L("fail to Fit::GetParameterResults!")
#define COMPILE_NLFITTING_FAILED_MSG _L("failed to compile NLFitting.c!")
#define INVALID_DATAPLOT_MSG _L("Invalid dataplot!")
#define BIN_COUNT_NOT_MATCH_MSG _L("Error, bin and count should match!")
#define COMPILE_MERGEGRAPHSDLG_FAILED_MSG _L("failed to compile MergeGraphsDlg.c!")
#define INVALID_SENDER_OBJECT_MSG _L("Invalid event sender object!")
#define INVALID_REGION_OBJECT_MSG _L("Error: not a valid region object!")
#define INVALID_MATRIX_LAYER_MSG _L("Error: invalid matrix layer!")
#define WARN_NOTHING_SELECTED _L("Error: nothing selected!")
#define DERIVATIVE_FAILED_MSG _L("Derivative failed.")
#define INTEGRATE_FAILED_MSG _L("Integrate failed.")
#define DATARANGE_GETDATA_FAILED_MSG _L("DataRange::GetData failed.")
#define NO_VALID_DATA_MSG _L("Error: no valid data!")
#define INVALID_SHRINK_COE_MSG _L("Error: invalid shrink coefficient!")
#define FAIL_SHRINK_MATRIX_MSG _L("Error: fail to shrink matrix!")
#define FAIL_SHOW_INFO_MSG	_L("Error: failed to show Data Info window!")
#define INVALID_FUNCTION_OR_DATAPLOT	_L("Error: invalid X-Function, or invalid DataPlot to assign X-Function!")
#define WARN_FEW_COLROW_NUMBER _L("Warning: too few col or row numbers!")
#define FAIL_COPY_DATA_ERR_MSG	_L("Error: fail to copy data from worksheet to matrix!")
#define RETRIEVE_DATA_ERR_MSG	_L("Error: failed to retrieve input data!")
#define NOT_REGULAR_ERR_MSG	_L("Error: x-y are not regular, try random conversion methods!")
#define NOT_SPARSE_ERR_MSG	_L("Error: x-y are not sparse, try random conversion methods!")
#define FAILED_GET_XYZ_MSG	_L("Error: failed to get XYZ data!")
#define FAILED_CREATE_GRIDDING_MSG	_L("Error: failed to create XY gridding!")
#define INVALID_DATA_TYPE _L("Error: the internal data type is not complex!")
*/
///end NOT_USED_MACRO
/// END WRONG_LOCALIZE_MACRO
///Don't add more entries here, see the remark in above.

///Cheney 2007-10-27 CLEAN_UP_LOCALIZATION_THINGS	
#define		STR_FITTED_CURVE_DATA_TYPE_SAME_INPUT		_LE("Same as Input Data")
#define		STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LINEAR	_LE("Uniform Linear")
#define		STR_FITTED_CURVE_DATA_TYPE_UNIFORM_LOG		_LE("Log")
#define 	STR_FITTED_CURVE_DATA_TYPE_SAME_SOURCE_GRAPH _LE("Use Source Graph Scale Type")			///Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
///end CLEAN_UP_LOCALIZATION_THINGS

#define	LOW_POW_PRE	4

#define WARN_NPARAM_UNUSED 123456789 ///---Sim 08-23-2006 WARNING_MSG_BOX

#define ORIGIN_PATH_USER75		-2		//------ Folger 09/03/07 CORRECTLY_GET_ORIGIN75_PATH

///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
/////Arvin 02/22/08 QA70-11151 SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
///// Hong 03/19/08 8.0827 NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME
////#define 	SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
//#define NLFIT_FDF_SETTINGS_SKIP_APPLY_THEME
///// end NLFIT_REMOVE_SETTINGS_ALLREADY_IN_FDF_FILE_FROM_THEME
/////end SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
#define 	SUPPORT_PARAMETERS_BRANCH_DYNAMICAL_ALLOCATION
///---END QA80-11371 THEME_SAVING_OPTIONS

///Arvin 02/28/08 QA70-11190 2D_FIT_SUPPORT_REPLICA
//#define  	2D_FIT_SUPPORT_REPLICA	CPY 5/5/08 DISABLE_REPLICA_FOR_SURFACE_FIT
///end 2D_FIT_SUPPORT_REPLICA

//Commetnts last updated by Frank on 1/06/05
/**
	Remark:
		Use to operator the nlsf.ini file.
	Keywords: 
*/
enum
{
	NLSF_SECTION_SAVE,
	NLSF_SECTION_DEL
};
///End FO_CODE_CLEAN_UP
//Commetnts last updated by Frank on 1/06/05

enum {DIFF_WKB, DIFF_WKS, SAME_WKS};

enum{CAL_POWER, CAL_SAMPLE_SIZE};

enum{TAIL_TWO_SIDE, TAIL_ONE_SIDE};

enum{CKBOX_UNSELECTED, CKBOX_SELECTED};

///Cheney 2006-11-13 MOVE_IT_INTO_ANALYSIS.H
enum{
	PLOT_TYPE_RAW_DATA,
	PLOT_TYPE_MEAN_SD,
	PLOT_TYPE_MEAN_SE
};

enum 
{
	/// Iris 2/25/2007 v8.0570 SUPPORT_INDEP_FIT_MODE
	//DATA_MODE_INDEP_CONSOLID,
	//DATA_MODE_INDEP_SEP,
	/// Iris 02/27/2007 v8.0570 RENAME_DATA_MODE_TO_AVOID_CONFUSE
	//DATA_MODE_INDEP_FIT,
	DATA_MODE_INDEP_CONSOLID,
	///end RENAME_DATA_MODE_TO_AVOID_CONFUSE
	DATA_MODE_INDEP_SEP,
	///end SUPPORT_INDEP_FIT_MODE
	DATA_MODE_CONCATENATE,
	/// Iris 02/27/2007 v8.0570 RENAME_DATA_MODE_TO_AVOID_CONFUSE
	//DATA_MODE_INDEP_CONSOLID,
	DATA_MODE_GLOBAL,
	///end RENAME_DATA_MODE_TO_AVOID_CONFUSE
};
///end MOVE_IT_INTO_ANALYSIS.H

///Arvin 12/27/06 ADD_RESIDUAL_ANALYSIS_FOR_FITTING
enum
{
	ANY_TYPE_RESIDUAL = -1, ///Arvin 10/23/07 QA70-10559-P3 SHOULD_NOT_CREATE_EMPTY_SHEET_WHEN_UNCHECK_ALL_RESIDUALS_CHECK_BOX
	REGULAR_RESIDUAL,
	STANDARDIZED_RESIDUAL,
	STUDENTIZED_RESIDUAL,
	STUDENTIZED_DELETED_RESIDUAL,
};
///END ADD_RESIDUAL_ANALYSIS_FOR_FITTING

///Sophy 1/9/2009 v8.0995 QA80-12591-P7 FIX_USE_SOURCE_GRAPH_SCALE_TYPE_GIVE_WRONG_RESULT move from graph_utils.h
//---- Iris 11/20/2008 v8.0975d QA80-12591-S1 CENTRALIZE_NEW_X_DATA_TYPE_AND_LOG_TYPE_CODES
enum
{
	SCALE_TYPE_LINEAR							= LINEAR_SPACE,
	SCALE_TYPE_LOG10							= LOG10_SPACE,
	SCALE_TYPE_PROBABILITY						= PROB_SPACE,
	SCALE_TYPE_PROBIT							= PROBIT_SPACE,
	SCALE_TYPE_PECIPROCA						= RECIPROCAL_SPACE,
	SCALE_TYPE_OFFSET_RECIPROCAL				= OFFSET_RECIP_SPACE,
	SCALE_TYPE_LOGIT							= LOGIT_SPACE,
	SCALE_TYPE_LN								= LOGE_SPACE,
	SCALE_TYPE_LOG2								= LOG2_SPACE,
	SCALE_TYPE_DOUBLE_LOG_RECIPROCAL			= DBL_LOG_SPACE,
};
//----
///end FIX_USE_SOURCE_GRAPH_SCALE_TYPE_GIVE_WRONG_RESULT

/**#
*/
bool get_scale_type(const GraphLayer& gl, int& nScaleType, bool bIsX);

///Arvin 06/07/07 CHANGE_LEGEND_TO_USE_LONG_NAME_AND_UNIT as max's suggestion
//Different Legend Types, used to set different type legends by code 
///Arvin 07/19/07 USE_STRING_TYPE_LEGEND_DIRECTLY as CP said
/*
enum
{
	LEGEND_DEFAULT,
	LEGEND_LL,  //@LL		= Long Name
	LEGEND_LS,	//@LS		= Short Name
	LEGEND_LA,	//@LA		= (Long Name if available else Short Name) 
	LEGEND_LN,	//@LN		= @LM + [@LU]	
	LEGEND_LM,	//@LM		= comment(1stline), or longname or short name, depending on presence in that order
	LEGEND_LG,  //@LG		= @LA + [@LU]
	
	//---Jake 07/13/07 GET_LEGEND_MODE_TYPE
	LEGEND_LD,	//@LD		= First User Parameter, best be present in data plot's worksheet to show 
	LEGEND_LP,	//@LP		= System Parameter 1. You can turn this on from the View context menu. 
	LEGEND_U,	//@U		= Column Long Name and Units (if present) 
	LEGEND_R,	//@R		= Full Range string in the form or [BookName]SheetName!Col_Name[Row_range] 
	//---end GET_LEGEND_MODE_TYPE
};
*/
///end USE_STRING_TYPE_LEGEND_DIRECTLY
///end CHANGE_LEGEND_TO_USE_LONG_NAME_AND_UNIT
///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
enum 
{
	NLF_PREV_FIT_CURVE,
	NLF_PREV_RESIDUAL,
	NLF_NO_PREV
};
///end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH

///Cheney 2007-5-14 RENAME_FIT_TOOL_CHECK_BOX_NAME
#define STR_FITTING_CHECKBOX_USE_RED_CHI_SQR  _L("Use Reduced Chi-Sqr")
///end RENAME_FIT_TOOL_CHECK_BOX_NAME

///---Sim 04-13-2007 MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF
// remove to dataids.h
///*$
//void testUserDataID()
//{
	//int nID = 1;
	//ASSERT(nID < USER_ID_COUNT);
	//int n1 = GET_USER_DATAID(nID);
	//out_int("ID1: ", n1);
	//
	//nID = 1000;
	//ASSERT(nID < USER_ID_COUNT);
	//int n2 = GET_USER_DATAID(nID);
	//out_int("ID2: ", n2);
	//
	//nID = 10001;
	//ASSERT(nID < USER_ID_COUNT);
	//int n3 = GET_USER_DATAID(nID);
	//out_int("ID3: ", n3);
//}
//**/
//#define DATAID_USER_BASE	0x04000
//#define USER_ID_COUNT		10000
//
//#define GET_USER_DATAID(_INDEX) (DATAID_USER_BASE + (_INDEX))
///---END MAKE_MECHANISM_FOR_USER_DATA_ID_IN_XF

/**@ >Mathematics>Data Gridding */
/**
	Remarks:
		Converts regular XYZ data to a matrix.
		If asked for, data is examined for deviations.
	Example1:
		//This example fill a matrix with values in the current worksheet.
		//For this samples to work, the current window is worksheet and contains 3 column A, B, C
		void convert_regular_xyz_to_matrix_ex1()
		{
			
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Dataset dsX(wks, 0);
				Dataset dsY(wks, 1);
				Dataset dsZ(wks, 2);
				vector vecX(dsX), vecY(dsY), vecZ(dsZ);
			
				MatrixLayer ml;						//Create a new Matrix to get the result
				ml.Create();
				Matrix matData(ml);
				
				double dXmax, dXmin;
				vecX.GetMinMax(dXmin, dXmax);		//Get the maximum and minimum values of X
				
				double dYmax, dYmin;
				vecY.GetMinMax(dYmin, dYmax);		//Get the maximum and minimum values of Y
			
				convert_regular_xyz_to_matrix(vecX, vecY, vecZ, matData, dXmin, dXmax, dYmin, dYmax);
			}
		}
	Parameters:
		vecX=[input] regular X data
		vecY=[input] regular Y data
		vecZ=[input] regular Z data
		dXmin=[input] minof x data - can use for setting coordinates of Matrix object
		dXmax=[input] max of x data - can use for setting coordinates of Matrix object
		dYmin=[input] min of y data - can use for setting coordinates of Matrix object
		dYmax=[input] max of y data - can use for setting coordinates of Matrix object
		bCheckData= [input] true: check data for irregularities; false: do no checking 
						If user knows data is perfectly regular, can set to false for faster operation
		matData = [output] storage the matrix data.
	Return:
		0:			success
		1:			XYZ vectors are of unequalsize, or result matrix smaller than 2x2
		2:			could not find steps in data
		3:			groups in x/y do not match group length in y/x
		4:			too much deviation in x/y data
	SeeAlso:
		convert_random_xyz_to_matrix_nag, convert_sparse_xyz_to_matrix
*/
///Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH
//int convert_regular_xyz_to_matrix(vector& vecX, vector& vecY, vector& vecZ, matrix& matData, double& dXmin,
									//double& dXmax, double& dYmin, double& dYmax, bool bCheckData = true);
///End OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH

//Commetnts last updated by Frank on 1/06/05
/** 
		Performs gridding of random XYZ data.
		The gridding is performed by calling NAG functions.
		Two gridding methods, Renka-Cline and Modified Shepard's method are available.
		For more details on these methods, see documentation for NAG function e01_sac.
	Example1:
		//This example fill a matrix with values in the current worksheet.
		//For this samples to work, the current window is worksheet and contains 3 column A, B, C
		void convert_random_xyz_to_matrix_nag_ex1()
		{
			
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Dataset dsX(wks, 0);
				Dataset dsY(wks, 1);
				Dataset dsZ(wks, 2);
				vector vecX(dsX), vecY(dsY), vecZ(dsZ);
			
				MatrixLayer ml;						//Create a new Matrix to get the result
				ml.Create();
				Matrix matData(ml);
				
				double dXmax, dXmin;
				vecX.GetMinMax(dXmin, dXmax);		//Get the maximum and minimum values of X
				
				double dYmax, dYmin;
				vecY.GetMinMax(dYmin, dYmax);		//Get the maximum and minimum values of Y
			
				int nRet = convert_random_xyz_to_matrix_nag(vecX, vecY, vecZ, matData, dXmin, dXmax, dYmin, dYmax);
			}
		}
	Parameters:
		vecX=[input] random X data
		vecY=[input] random Y data
		vecZ=[input] random Z data
		matResult =[output]	matrix with gridded data
		dXmin=[input] min of x data - can use for setting coordinates of Matrix object
		dXmax=[input] max of x data - can use for setting coordinates of Matrix object
		dYmin=[input] min of y data - can use for setting coordinates of Matrix object
		dYmax=[input] max of y data - can use for setting coordinates of Matrix object
		iMethod=[input] 0: Renka-Cline gridding; <>0: Modified Shepard's method
		dQIL=[input] Quadratic Interpolant Locality - used only by Shepard's method
		dWFL=[input] Weight Function Locality - used only by Shepard's method
	Return:
		0:		success
		-1:		Error in creating matrix
		NAG 	error codes:
		70: 	Parameter method had an illegal value.
		11: 	The number of points is less than 3.
		73: 	Memory allocation failed.
		245: 	All the (x,y) pairs are collinear.
		246: 	Data pair is not unique. Duplicate points are found in the (x,y) pair.
		247: 	Invalid dQIL and dWFL for Shepard's method.
		249: 	(Warning)The minimum number of data points that lie within the radius of 
				any node is smaller that the interpolant may be unsatisfactory in regions 
				where the data points are sparse.
		251: 	(Warning)The evaluation point lies outside the triangulation boundary.  
				The returned value was computed by extrapolation.
		252: 	On entry,the interpolant cannot be evaluted because the evaluation 
				point is outside the support region of the input data points.
	SeeAlso:
		convert_regular_xyz_to_matrix
*/ 
///Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH
//int convert_random_xyz_to_matrix_nag(vector& vecX, vector& vecY, vector& vecZ, 
			//matrix& matResult, double& dXmin, double& dXmax, double& dYmin, double& dYmax, 
			//int iMethod = 0, double dQIL = 1, double dWFL = 1);
///End OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH

//Commetnts last updated by Frank on 1/06/05
/** >Mathematics>Vector Analysis
		Removes duplicate points from XYZ data.
		Duplicates are replaced with mean Z value.
	Example1:
		//This example removes the duplicated values in the current worksheet.
		//For this samples to run, the current worksheet should exist in the project with A, B, C columns.
		void xyz_remove_duplicates_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Dataset dsX(wks, 0);
				Dataset dsY(wks, 1);
				Dataset dsZ(wks, 2);
				vector vecX(dsX), vecY(dsY), vecZ(dsZ);
				
				xyz_remove_duplicates(vecX, vecY, vecZ);
				
				dsX = vecX;
				dsY = vecY;
				dsZ = vecZ;
			}
		}
	Parameters:
		vecX=[modify] before input have X data; Output X vectors with duplicates removed
		vecY=[modify] before input have Y data; Output Y vectors with duplicates removed
		vecZ=[modify] before input have Z data; Output Z vectors with duplicates removed
	Return:
		0:			success
		1:			XYZ vectors are of incorrect length
*/
//int xyz_remove_duplicates(vector& vecX, vector& vecY, vector& vecZ);///Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH


//Commetnts last updated by Frank on 1/06/05
/** >Mathematics>Data Gridding
		Converts sparse XYZ data to a matrix.
		Sparse data is regular data with some rows missing.
	Example1:
		//This example convert column A, B, C  into a sparse matrix.
		//For this sample to run, current worksheet with column A, B, C must exist. 
		void convert_sparse_xyz_to_matrix_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Dataset dsX(wks, 0);
				Dataset dsY(wks, 1);
				Dataset dsZ(wks, 2);
				vector vecX(dsX), vecY(dsY), vecZ(dsZ);
				
				MatrixLayer ml;
				ml.Create();				// Create a new matrix to get the result
				Matrix matData(ml);
				
				double dXend, dXbegin;
				double dYend, dYbegin;
				double dXstep; 
				double dYstep; 
				
				convert_sparse_find_min_max_step(vecX, dXbegin, dXend, dXstep); //Find the step
				convert_sparse_find_min_max_step(vecY, dYbegin, dYend, dYstep);	//Find the step
				
				convert_sparse_xyz_to_matrix(vecX, vecY, vecZ, matData, dXbegin, dXend, dXstep, 
							dYbegin, dYend, dYstep);
			}
		}
	Parameters:
		vecX=[input] regular X data
		vecY=[input] regular Y data
		vecZ=[input] regular Z data
		matResult=[output] resulting matrix
		dXbegin=[input] min in X. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		dXend=[input] max in X. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		dXstep=[input] stepsize in X. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		dYbegin =[input] min in Y. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		dYend=[input] max in Y. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		dYStep = [input] stepsize in Y. 
							  	Call convert_sparse_find_min_max_step to estimate these values.
		iPrecision=[input] precision used to locate values; same as under Data_list() function
 	Return:
				0:				All points were converted
				-1:				xyz vectors are of different/incorrect size
				-2:				Matrix size too large - could be due to very small step value
				-3:				Error in creating matrix object
				positive:		Number of points that were discarded
	SeeAlso:
		convert_regular_xyz_to_matrix
		
*/
//int convert_sparse_xyz_to_matrix(vector& vecX, vector& vecY, vector& vecZ, matrix& matResult, double dXbegin, double dXend, double dXstep, double dYbegin, double dYend, double dYstep, int iPrecision = 8);///Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH


//Commetnts last updated by Frank on 1/06/05
/** >Mathematics>Data Gridding
		Compute min, max and step value for sparse matrix conversion.
	Example1:
		//This example convert column A, B, C  into a sparse matrix.
		//For this sample to run, current worksheet with column A, B, C must exist. 
		void convert_sparse_find_min_max_step_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Dataset dsX(wks, 0);
				vector vec(dsX);
				
				
				double dMin, dMax, dStep;

				int iRet = convert_sparse_find_min_max_step(vec, dMin, dMax, dStep);
			}
		}
	Parameters:
		vec=[input] vector with data
		dMin=[output] min values
		dMax=[output] max values
		dStep=[output] step values
	Return:
		0:			success
	SeeAlso:
		convert_sparse_xyz_to_matrix
*/
//int convert_sparse_find_min_max_step(vector& vec, double& dMin, double& dMax, double& dStep);///Frank 4/7/05 OC_CONVERT_MATRIX_FUNCTION_MOVE_TO_VC_LEVEL_WITH_PREFIX_OCMATH


//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_get_wks_col_names_(global_function)
*/
string curve_get_wks_col_names(const curvebase& cuv, string& strX, string& strY);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_both_in_layer_(global_function)
*/
bool curve_both_in_layer(const curvebase& cuv1, const curvebase& cuv2, GraphLayer& glayerFound);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_update_(global_function)
*/
bool curve_update(curvebase& cuvResult, const curvebase& cuvInput, const TreeNode& trInput, int nColor, bool bRescale = false);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_update_in_page_(global_function)
*/
bool	curve_update_in_page(curvebase& cuv, int nColor, GraphPage &gpg, bool bRescale = false);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_in_page_get_indices_(global_function)
*/
BOOL	curve_in_page_get_indices(const curvebase& cuv, const GraphPage &gpg, int *pnLayerIndex = NULL, int *pnDataPlotIndex = NULL);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_curve_to_graph_layer_(global_function)
*/
bool	add_curve_to_graph_layer(curvebase& cuv, GraphLayer &grl, int nColor = 2, bool bRescale = false, int nPlotType = IDM_PLOT_LINE);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_in_layer_get_index_(global_function)
*/
int curve_in_layer_get_index(const curvebase& cuv, const GraphLayer& gl);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_curve_(global_function)
*/
bool set_curve(const curvebase& cuv, TreeNode& trNode);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_active_layer_(global_function)
*/
bool set_active_layer(TreeNode& trNode);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_graph_layer_(global_function)
*/
GraphLayer get_graph_layer(const TreeNode& trNode);

//Commetnts last updated by Iris on 2007.8.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:set_active_layer_(global_function)
*/
bool set_active_layer(Layer& layr);

//Commetnts last updated by Joseph on 7/30/07
/**# >Curve
		prepare a treenode with proper info for the given curve
	Parameters:
		cuvInput =[input] the data curve that we will be using
		trInput =[input] a tree branch that has a Range1 branch that we will need to initialize
		i1 =[input] beginning drawing range of the cuvInput
		i2 =[input] ending drawing range of the cuvInput, inclusive
		hWndRet =[input] only if bNeedInit = false, the graph window's handle where the cuvInput is activated
		bNeedInit = [input] true will init the trInput node, = false will make use the trInput to activate the graph layer
	Example1:
		//This example prepare the plotting of the data in column B.
		//For this sample to run, a Worksheet with column B should exist in the project.
		void set_curve_input_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			if(wks)
			{
				Curve crv( wks, 1 );
				Tree trInput;
				int iBegin, iEnd;
				HWND hWndRet;
				set_curve_input(crv, trInput, iBegin, iEnd, hWndRet);
				out_tree(trInput);
			}
		}
	Return:
		true  if the cuvInput is full range, false if cuvInput has selected subrange.
*/
bool set_curve_input(const curvebase& cuvInput, TreeNode& trInput, int& i1, int& i2, HWND& hWndRet, bool bNeedInit = true);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_duplicate_active_(global_function)
*/
curvebase& curve_duplicate_active(LPCSTR lpcszNewColName = NULL, bool bReuseIfInWks = false);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_smooth_adjave_(global_function)
*/
bool curve_smooth_adjave(curvebase& cuv, int leftpts);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_smooth_sg_(global_function)
*/
bool curve_smooth_sg(curvebase& cuv, int npts, int nDeg = 2);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Curve_derivative_(lowcase)_(global_function)
*/
bool curve_derivative(curvebase& cuv);

enum {
	CUVS_X_MARKERS_NEAREST = 0x1000, // consider data nearest to x, if not set, then consider data between but exclude markers
	CUVS_DUMP_SCRIPTWIN = 0x2000, // if set, then output to script window
};

///Leo 2005-12-16 MOVED_PEAK_AND_BASLINE_FUNCS_TO_PFM_UTILS

//----------- CPY 4/3/05 SIMPLE_GRAPH_ANSLYSIS_FUNCTIONS
//Commetnts last updated by Cheney on 2007.4.13
//Category last updated by Cloud on 6/11/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_stats_(global_function)
*/
bool curve_stats(double x1, double x2, DWORD dwCntrl, DataPlot& dataplot = NULL);

//Commetnts last updated by Iris on 2007.8.23
//Category last updated by Cloud on 6/11/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_stats_(global_function)
*/
bool curve_stats(const DataRange& dr, TreeNode& tr);

/// YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
//Commetnts last updated by Iris on 2009.8.3, used in XF so put to help
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:curve_stats_(global_function)
*/
bool curve_stats(const vector& vx, const vector& vy, TreeNode& tr);
/// end CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER


#define SWAP(i1,i2,it)  it=i1,i1=i2,i2=it

//Commetnts last updated by Iris on 2007.8.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_dataplot_index_(global_function)
*/
int get_dataplot_index(DataPlot& dp, double x, DWORD dwCntrl = XIC_NEAREST_ANY);

/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
#define		STR_TR2WKS_NO_RENAME_SNAME_ATTRIB		"TR2WKS_NO_RENAME_SNAME"
/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
//Commetnts last updated by Iris on 2007.8.23
//Category last updated by Cloud on 6/11/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_tree_to_wks_(global_function)
*/
int out_tree_to_wks(const TreeNode& tr, Worksheet& wks);

//Commetnts last updated by Iris on 2007.8.23
//Category last updated by Cloud on 6/11/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:out_tree_to_wks_(global_function)
*/
///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
//int out_tree_to_wks(const TreeNode& tr, LPCSTR lpcszBookName);
int out_tree_to_wks(const TreeNode& tr, LPCSTR lpcszBookName, DWORD dwCtrl = CREATE_VISIBLE | CREATE_LOAD_1ST_LAYER_ONLY);
///end ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT


///Sophy 1/7/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
#define	ATTACHED_GRAPH_OBJECTS_INFO		"AttachedGraphObjects"
///end CLEAN_CODE_FOR_ROI_TOOLS

//Commetnts last updated by Iris on 2007.8.27
/**$
*/
///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
//bool find_intersect_dataplot(GraphObject& grTool, DataPlot& dp, int& i1, int& i2, bool bUpdateToActive = true);
bool find_intersect_dataplot(GraphObject& grTool, DataPlot& dp, int& i1, int& i2, bool bUpdateToActive = true, DWORD dwCtrl = 0);
///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA

/// YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
/**$
*/
///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
//bool find_intersect_dataplot(GraphObject& grTool, DataPlot& dp, vector& vX, vector& vY, bool bUpdateToActive = true);
bool find_intersect_dataplot(GraphObject& grTool, DataPlot& dp, vector& vX, vector& vY, bool bUpdateToActive = true, DWORD dwCtrl = 0);
///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
/// end CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
///Sophy 10/28/2008 SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP moved to analysis_utils.h
/**$
*/
void stats_check_reset_fit_mode(TreeNode & trInputData, int nTotalNumData, int numSubData = 0);
///end SHOULD_REARRANGE_LAYERS_WHEN_SWITCH_BETWEEN_SINGLE_INDEP_N_DEP_AND_MULTI_IDEP_N_DEP

//Commetnts last updated by Iris on 2007.8.27
//Category last updated by Cloud on 6/11/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_xy_data_(global_function)
*/
bool get_xy_data(const DataRange& dr, vector& vx, vector& vy, int* pi1 = NULL, int* pi2 = NULL, bool bGetMissingValues = true, Worksheet* pwks = NULL);

/**#
*/
bool interpolate_linear(const vector& vx, vector& vy, double x1, double y1, double x2, double y2);

/**#
*/
///Arvin 03/19/07 IMPROVE_CALCULATION_CENTROID_METHOD
//bool peak_integrate(const vector& vx, const vector& vy, const vector& vbln, ocmath_IntegResult& ir);
bool peak_integrate(const vector& vx, const vector& vy, const vector& vbln, IntegrationResult& ir);
///end IMPROVE_CALCULATION_CENTROID_METHOD
/**#
*/
bool grobj_stretch_vertical(GraphObject& gr, DataRange& dr, bool bData = true);

/**#
*/
//bool shape_tool_init(GraphObject& gr, int nPatternColor = 6, int nPatternStyle = 6, double nBorderWidth = 0.5, double nPatternWidth = 0.2, int nFillColor = -4, bool bBehindData = true);
bool shape_tool_init(GraphObject& gr, int nPatternColor = 6, int nPatternStyle = 0, double nBorderWidth = 0.5, double nPatternWidth = 0.2, int nFillColor = 20, bool bBehindData = true);

/**#
*/
void tree_set_add_col_info(TreeNode& tr, int nDesignation, int nColWidth = 0);

/**#
*/
/// ML 11/1/2005 QA70-8254 INVOKING_OPERATION_FROM_XFUNCTION
//bool do_AU_command(LPCSTR lpcszClassname, BOOL bOpenGUI, LPCSTR lpcszThemeName = NULL, int nOption = 0, DataRange& drInput = NULL);
/// Hong 12/24/09 QA80-14832 NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
//bool do_AU_command(LPCSTR lpcszClassname, BOOL bOpenGUI, LPCSTR lpcszThemeName = NULL, int nOption = 0, DataRange& drInput = NULL, LPCSTR lpcszName = NULL);
///Sophy 1/11/2010 SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
//bool do_AU_command(LPCSTR lpcszClassname, BOOL bOpenGUI, LPCSTR lpcszThemeName = NULL, int nOption = 0, DataRange& drInput = NULL, LPCSTR lpcszName = NULL, bool bFromHotkey = false);
bool do_AU_command(LPCSTR lpcszClassname, BOOL bOpenGUI, LPCSTR lpcszThemeName = NULL, int nOption = 0, DataRange& drInput = NULL, LPCSTR lpcszName = NULL, DWORD dwExeCtrl = 0, DWORD dwParam = 0);
///end SUPPORT_OPEN_NLFIT_FROM_QUICKFIT_CONTEXT_MENU
/// end NLFIT_OPEN_BY_HOTKEY_SOPPORT_APPLY_SETTING_FROM_QUICKFIT_WITHOUT_ANY_THEME
/// end INVOKING_OPERATION_FROM_XFUNCTION


/**#
*/
bool frequency_count(const vector& vy, vector<uint>& vecFCount, double& min, double& max, double& dbinW, int nBinRule = BIN_RULE_STURGES);
//-----------
/// Iris 12/28/2006 UPDATE_REPORT_TABLE_COL_NAME_FROM_P_TO_C
//#define	CALCULATION_PARAMETER_PREFIX		"P" //CPY 6/8/04, changed from P
#define	CALCULATION_REPORT_TABLE_COL_PREFIX		"C"
#define	CALCULATION_REPORT_TABLE_ROW_PREFIX		"R"
/// end UPDATE_REPORT_TABLE_COL_NAME_FROM_P_TO_C
#define CALCULATION_PERCENTILE_PREFIX		"Perct"
#define	CALCULATION_FIT_CURVES_PREFIX		"Fit"	
#define CALCULATION_GRAPH_NODE_PREIX		"Picture"
#define CALCULATION_GRAPH_INFO_PREIX		"PlotInfo"
#define CALCULATION_BIN_DATA_TABLE			"BinWks"
#define CALCULATION_RESIDUAL_GRAPH_PREIX    "Residual"

/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
/*
//---CPY 6/9/04 taken from stats_gui.h
// *** Common ***
#define STR_TOKEN_SEP					"|"
#define STR_SOURCE_BOOK					_L("<source>")
#define STR_REPORT						_L("<report>")
#define STR_INSERT_SOURCE_SHEET			STR_SOURCE_BOOK
/// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
//#define STR_CUSTOM						_L("<custom>")  ///Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
#define STR_EXISTING					_L("<existing>")
#define STR_CUSTOM						STR_EXISTING
/// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
#define STR_ACTIVE						_L("<active>")/// YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION
#define	STR_SAME						_L("<same>") /// YuI 05/20/05
#define STR_THREE_DOTS					_L("...")  ///Iris 11/16/04
*/
///end  MOVE_GET_CLASS_SETTINGS_TO_VC
 
//---------------- CPY 10/8/04 QA70-7025 v8.0147 REPORT_BOOK_INDICATE_SOURCE_BOOK 
// predefined strings from above and corresponding ID
/**#
*/
/// DSC 5//23/05 MOVE_GET_CLASS_SETTINGS_TO_VC
/*
enum {
	PDS_USER, // user supplied string
	PDS_NEW,
	PDS_NONE,
	PDS_SOURCE,
	PDS_REPORT,
	/// ML 3/3/2005 XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
	/////Iris 11/12/04 QA70-7139 ADD_CUSTOM_OPTION_TO_REPORT
	//PDS_CUSTOM,	
	/////--
	PDS_EXISTING,	
	PDS_CUSTOM = PDS_EXISTING,	
	/// end XFUNCTION_OUTPUT_VARIABLES_DATA_ASSOC
	
	///DSC 3/25/03 CLEANUP_LAST_USED
	PDS_LAST_USED,
	PDS_FACTORY_DEFAULT,
	///end CLEANUP_LAST_USED

	PDS_ACTIVE, /// EJP 2005-04-15 v8.0223 CLEAN_ACTIVE_IMPLEMENTATION
	PDS_SAME, /// YuI 05/20/05
PDS_TOTAL
};
*/
/// end MOVE_GET_CLASS_SETTINGS_TO_VC


//---------------- end
/**#
*/
int str_to_predefined_type(LPCSTR lpcszStr, string* pstr = NULL);


//#define STR_DEPENDS_ON					"DependsOn"
//---

//----- Iris 06/01/2007 v8.0631 want to use them in xf, so move to tree_utils.h
///**#
	//add more label attributes to a tree node
//*/
//void	tree_add_more_labels(TreeNode &trParent, vector<string> &vstrFactors, int nStartIndex = 0, LPCSTR lpcszLastLabel = NULL);
///**#
//*/
//void	tree_add_one_label(TreeNode &trParent, LPCTSTR lpcszLabel, int index = -1);
//----- 

/**#
*/
TreeNode	check_add_enumerated_node(TreeNode &trParent, LPCTSTR lpcszPrefix, int index, int nID = -1, LPCSTR lpcszAttrib = NULL, LPCSTR lpcszAttribVal = NULL);

/// end REPORT_TABLE_MULTIHEADERS_MORE_WORK

/// YuI 12/07/04 v7.5172 PICTURE_IN_REPORT_IMPROVEMENT
//Commetnts last updated by Frank on 1/10/05
/**#
*/
//this function is conterpart of check_add_enumerated_node
//it will return node but will not create it is not there
TreeNode	get_enumerated_node(TreeNode &trParent, LPCTSTR lpcszPrefix, int index);
/// end PICTURE_IN_REPORT_IMPROVEMENT

//----- CPY 6/9/04 MOVE_REPORT_BRANCH_TO_BASE_CLASS
// dwOptions can be combination of	
enum {
REPORT_NOTES = 			0x01,
REPORT_INPUT = 			0x02,
REPORT_PARAMETERS = 	0x04,
REPORT_GRAPHS = 		0x08, 
REPORT_ANOVA_TABLE = 	0x10,
REPORT_2ND_GRAPHS = 	0x20,/// ----Iris 9/10/04 OUTPUT_ADD_2ND_GRAPH
REPORT_MASKED_DATA = 	0x40,/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
REPORT_3RD_GRAPHS =		0x80,/// Iris 11/11/04 OUTPUT_ADD_THIRD_GRAPH_FOR_ANOVA_ONE_WAY

REPORT_CUSTOM_TABLE1 = 	0x0100, //CPY 11/10/04 QA70-7121 CUSTOM_REPORT_TABLES
REPORT_CUSTOM_TABLE2 = 	0x0200, //CPY 11/10/04 QA70-7121 CUSTOM_REPORT_TABLES
REPORT_CUSTOM_TABLE3 = 	0x0400, //CPY 11/10/04 QA70-7121 CUSTOM_REPORT_TABLES


REPORT_CALIBRATION_TABLE = 0x2000, ///Iris 11/15/04 QA70-7120 CALIBRATION_REPORT_TABLE
/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
REPORT_MISSING_DATA = 	0x4000,
/// end GETTING_MISSING_VALUES_AND_ROWS

//REPORT_FORMULA_SOURCE_GRAPH = 	0x8000, ///Iris 12/23/04 QA70-7135 INSERT_FORMULA_TO_SOURCE_GRAPH

REPORT_PASTE_RESULT_TABLES_TO_GRAPH = 0x8000, /// Iris 8/16/05 QA70-7889 CONTROL_IF_ADD_RESULT_TABLE

REPORT_KEEP_SESSION_GRAPH =     0x10000, ///Iris 6/06/05

REPORT_RESIDUAL_TABLE = 0x40000, ///Iris 4/01/05 FIT_REGRESSION_PLOTS

REPORT_GRAPH_PLOT_INFO = 0x80000, ///Iris 4/16/05 GUI_GRAPH_NODE_IF_NEED_PLOTINFO

REPORT_REPORT_MAT_DATA = 0x100000, /// Iris 9/06/06 SURFACE_FIT_REPORT_MAT_FIT_DATA

REPORT_RESULT_CURVE_OPTION = 0x200000,	/// Iris 01/19/2007 v8.0544 OPTION_ON_OUT_RESULT_CURVE_SHEET_SEPARATELY_OR_NOT

REPORT_ARRANGE_GRAPHS_TO_COLS = 0x400000, /// Iris 01/08/2007 v8.0538 REPORT_GRAPHS_ARRANGEMENT

REPORT_PLOT_ALL_PLOTS_IN_ONE_GRAPH = 0x800000, /// Iris 02/03/2007 v8.0554 PLOT_ALL_BOX_CHART_IN_ONE_GRAPH

REPORT_LAST_ITEM};


/**#
*/
void tree_construct_add_input_branch(TreeNode& trGUI, int nDataMode = INPUTDATA_CURVES);
//void tree_construct_add_report_branch(TreeNode& trGUI, DWORD dwOptions, int nReportBranchID = 0, int nCurveBranchID = 0, int nResidualBranchID = 0, int nGraphNum = 0);

/**$
*/
void tree_construct_add_common_report_table_options(TreeNode& trBranch, DWORD dwOptions);

/**$
*/
void tree_construct_add_graph_options(TreeNode& trBranch, int nNumGraphs, DWORD dwOptions);

/**$
*/
void tree_construct_add_plot_settings(TreeNode trBranch, DWORD dwOptions);

/**#
*/
bool tree_construct_prepare_report_sheet_node(TreeNode& trGUI, Worksheet& wksReport = NULL);

/**#
*/
bool tree_check_set_hidden(TreeNode& tr, bool bMakeHidden = true);

/**#
*/
int tree_get_plot_UIDs(const TreeNode& trInputData, vector<uint>& vPlotUIDs);

/**#
*/
int get_layer_plots(vector<int>& PlotIndexList, vector<string>& vsDescriptions = NULL, vector<uint>& PlotUIDsToExclude = NULL, bool bRemoveHiddenPlots = true);
//TreeNode tree_check_add_input_data_branch(TreeNode& trInputData, const vector<string>& vsKeys, vector<string>& vsLabels, int nBranchType, int nData = 1, int nType = -1, LPCSTR lpcszDefaultVal = NULL);
//bool tree_check_add_input_data_branch(TreeNode& trInputData, DataPlotStrings* pDPS, int nData, uint uID);

/**#
*/
bool tree_check_add_input_data_branch_active_layer(TreeNode& trInputData, int nPlot, bool bAdd1st = false);

/// ML 4/18/2005 XFUNCTION_TREE_MANIPULATION_IN_VC
//enum {
//	DBTY_X_FUNC_VAR						= 0,
//	DBTY_CURVE_OUTPUT
//};
//#define			DATA_BRANCH_TYPE(_dwOptions)				(_dwOptions)
/// end XFUNCTION_TREE_MANIPULATION_IN_VC
/**#
*/
void tree_construct_xvar_data_branch_subnode(TreeNode& trData, int nDataType);


/**#
*/
uint tree_get_plot_uid(const TreeNode& trInputDataSub);
/// YuI 6/16/04 v7.5891 QA70-6556 DATA_RANGE_MARKERS
//	DataSelector get_data_selector(const TreeNode& trInputDataSub, bool bCreate = false);

/**#
*/
DataSelector get_data_selector(const DataRange& dr, int nSubRange, bool bCreate = false);
/// end DATA_RANGE_MARKERS

//-----

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_col_by_name_(global_function)
*/
int find_col_by_name(Worksheet& wks, LPCSTR lpcszName);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_insert_column_(global_function)
*/
int	wks_insert_column(Worksheet &wks, int nDesiredColumnPosition, Column &col);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_get_book_sheet_name_(global_function)
*/
string wks_get_book_sheet_name(const Datasheet& ds);

//Commetnts last updated by Joseph on 2007.7.30
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_from_book_sheet_name_(global_function)
*/
bool wks_from_book_sheet_name(Worksheet& wks, const string& strBookSheet);

//Commetnts last updated by Joseph on 2007.7.30
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:make_book_sheet_name_(global_function)
*/
string make_book_sheet_name(const string& strBook, const string& strSheet);

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_book_sheet_names_(global_function)
*/
bool get_book_sheet_names(const string& strBookSheet, string& strBook, string& strSheet);

//Commetnts last updated by Frank on 1/10/05
/**$
		It adds or just retrieves a column from the DataRange according to the slot index indexInRange inside the DataRange.
		A column is added to the worksheet as needed. The function decides on whether it considers the column to already exist
		based on the presence of the range inside the provided DataRange at the required slot.
	Parameters:
		wks=[input] the worksheet hosting the column
		rngInsertedColumns=[input] the DataRange object holding the information about the column at the slot indexInRange. If the
							information is absent, it will be added as the column is added to the worksheet.
		lpcszName =[input] the unique named DataRange inside rngInsertedColumns
		col=[output] the column to be retrieved.
		nDesiredColumnPosition=[input] the desired position of the column if the column is to be added. If less than 0,
								the column will be appended. If >= 0, but the current total number of
								columns in wks is less than nDesiredColumnPosition, the column will still be appended.
		r1=[input]the starting row of the range to add or update
		r2=[input]the ending row of the range to add or update
	Return:
		the index of the column inside the worksheet
							
*/
int check_insert_output_column(Worksheet &wks, DataRange &rngInsertedColumns, LPCTSTR lpcszName, Column &col, int nDesiredColumnPosition=-1, int r1=0, int r2=-1);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_input_range_bounding_box_(global_function)
*/
int find_input_range_bounding_box(const DataRange& rngInput, int& r1, int& c1, int& r2, int& c2, Worksheet& wksFirst, LPCSTR lpcszType);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_input_range_bounding_box_(global_function)
*/
bool find_input_range_bounding_box(const DataRange& rngInput, int& r1, int& c1, int& r2, int& c2, Worksheet& wks, int nDataIndex, string strTypeSeparator = "Y");

/// YuI 8/13/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
/**$
*/
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//#define STR_DATARANGE_UID_ATTRIB	"DataRangeUID" //CPY 10/20/04 SAVE_SEL_RANGE_TO_INPUT_DATA
/// end XVARIABLEBASE_TO_VC

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//typedef enum {
//	ERR_UNKNOWN,
//	ERR_DATASEL_NO_DATA_SELECTED,
//	ERR_DATASEL_MUST_HAVE_Z,
//	ERR_DATASEL_MUST_HAVE_Y,
//	ERR_DATASEL_MUST_HAVE_X, //for MR
//} ORIGIN_ERROR_CODES;
/// end XVARIABLEBASE_TO_VC
/**$
	error message from error code for functions like init_input_data_branch_from_selection
*/
string get_err_as_string(int nErrCode);
	
/**$
		Initialize a tree branch with current selection. The resulting tree is structured with a Range1 sub branch
	Keywords:
		Selection; Operation; Input Data; Data Range
	Example1:
		// sel XY data and fit with LR
		BOOL lr_sel_data()
		{
			Tree tr;
			init_input_data_branch_from_selection(tr, DRR_GET_DEPENDENT);
			out_tree(tr);
			DataRange dr;
			// tr has Range1 sub-branch, create multiple will create without Range1 and thus directly X, Y
			dr.Create(tr, false);
			DWORD dwPlotID;
			vector vy, vx;
			if(dr.GetData(DRR_GET_MISSING |  DRR_GET_DEPENDENT | DRR_NO_FACTORS, 0, &dwPlotID, NULL, &vy, &vx) < 0)
				return false;
			
			vector vc;
			fitlinear(vx, vy, vc);
			printf("N=%d, slope = %g\n", vx.GetSize(), vc[1]);
			return true;
		}
	Example 2:
		// sel XYZ data in wks, or just select a Z col
		void plot_3d()
		{
			Tree tr;
			if(!init_input_data_branch_from_selection(tr, DRR_GET_Z_DEPENDENT))
			{
				out_str("no data selected");
				return;
			}
			DataRange dr;
			dr.Create(tr, false);
			GraphPage gp;
			// you must use a 3D scatter/line template, you can first make a 3d scatter plot, 
			// make the needed modification, then save into your own
			gp.Create("3D"); 
			GraphLayer gl = gp.Layers();
			gl.AddPlot(dr, ID_3D_GRAPH_SCATTER);
			gl.Rescale();
		}

	Parameters:
		trInputData=[output] a TreeNode to receive the resulting Data Range tree structure
		dwDataRule=[input] 0 if getting selection as is selected in worksheet, DRR_GET_DEPENDENT to get XY with error, DRR_GET_Z_DEPENDENT to get XYZ
		pnErrCode=[input] optional error codes, see ERR_DATASEL_NO_DATA_SELECTED defined in the ORIGIN_ERROR_CODES enum
		obj = [input] if not null use the object to get its selection
		pnInputPageType = [output] the window type of the selected input data, such as EXIST_WKS, EXIST_GRAPH.
	Return:
		Returns true if there is a valid selection
	SeeAlso:
		DataRange::Add, DataRange::Create, Project::GetSelection
*/
bool	init_input_data_branch_from_selection(TreeNode& trInputData, DWORD dwDataRule, int* pnErrCode = NULL, OriginObject& obj = NULL, int *pnInputPageType = NULL);
/**$
	Return:
		Returns trInputData if bAddToProject and trInputData was not yet prepared
*/
/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE
//bool prepare_input_data_for_operation(TreeNode& trInputData, bool bAddToProject = true);
bool prepare_input_data_for_operation(TreeNode& trInputData, bool bAddToProject = true, int nDRTreeOption = DRTREE_DEFAULT);
/// ML 10/20/2005 ANOVA_INPUT_DATA_TO_DATARANGE

///Iris 11/11/04 IMPROVE_INIT_INPUT_DATA_SELECTION
//bool init_input_data_branch_from_selection(TreeNode& trInputData, vector<int>& vnShow);   ///Iris 10/21/04 ADD_OPTION_TO_SELECT_INPUT_RANGE
// CPY 5/15/05 CONSOLIDATE_INIT_INPUT_DATA_RANGE
/*
enum{
	DATA_RANGE_ALL = 0, 
	DATA_RANGE_EXCLUDE_DATA = 0x0001, 
	DATA_RANGE_EXCLUDE_GROUP = 0x0002, 
	DATA_RANGE_EXCLUDE_WEIGHT  =0x0004,
};
*/

/**#
		Construct a tree node that represents a data range for columns in a worksheet.
	Keywords:
		
	Example1:
	
	Parameters:
		tr=[output]
		wks=[input]
		lpcszX=[input]
		lpcszY=[input]
		lpcszZ=[input]
		lpcszErr=[input]
		bSingle=[input]
	Return:
		
	SeeAlso:
		init_input_data_branch_from_selection, DataRange::Add, DataRange::Create
*/
bool construct_one_data_range(TreeNode& tr, const Worksheet& wks, LPCSTR lpcszX, LPCSTR lpcszY, LPCSTR lpcszZ = NULL, LPCSTR lpcszErr = NULL, bool bSingle = true);

/**$
*/
TreeNode tree_check_add_input_data_branch(TreeNode& trInputData, const vector<string>& vsKeys, vector<string>& vsLabels, int nBranchType, int nData = 1, int nType = -1, LPCSTR lpcszDefaultVal = NULL);
/// end NLFITTER_OPERATION_IMPLEMENTATION

/**$
*/
TreeNode tree_check_add_input_data_branch(TreeNode& trInputData, const DataPlot& dp, int nData = 1);

/**#
	construct a tree node that represents all the data plots in the given graph
*/
bool construct_data_range_all_plots(TreeNode& tr, GraphLayer gl);

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_nearest_xy_at_x_(global_function)
*/
bool find_nearest_xy_at_x(double x, const DataRange& dr, vector<string>& vsNames, vector<int>& vnIndices, vector& vx, vector& vy);

/// YuI 11/11/04
/**$
*/
DataRange	get_data_range_from_input_data(TreeNode& trInputData, uint& uidDataRange);
/// end YuI 11/11/04

/// ML 8/17/2004 QA70-6825 RLOG_QUERY
/**#$
*/
int		make_one_set_ID(int idBase, int nDataIndex);
/// end RLOG_QUERY

// CPY 9/2/04 some common strings for Anlaysis dialog and reports

// common label for the branch to decide which quantities to calculate
#ifndef OP_DLG_TOTALLY_NEW_STRUCTURE
#define STR_CALC_OPTIONS _L("Quantities to Compute")	
#else
#define STR_CALC_OPTIONS _L("Output Tables")	
#endif 

#define STR_INPUT_DATA	_L("Input Data")
/// ML 10/20/2004 QA70-7075 MASKED_DATA_REPORTING
#define STR_MASKED_DATA	_L("Masked Data")
#define STR_MASKED_DATA_LONG _L("Masked Data - Values Excluded from Computations")
/// end MASKED_DATA_REPORTING
/// ML 12/14/2004 QA70-7240 GETTING_MISSING_VALUES_AND_ROWS
#define STR_MISSING_DATA	_L("Missing Data")
#define STR_MISSING_DATA_LONG _L("Bad Data (missing values) -- Values that are invalid and thus not used in computations")
/// end GETTING_MISSING_VALUES_AND_ROWS

#define STR_NOTES_TABLE	_L("Notes")
#define STR_ANOVA_TABLE _L("ANOVA")
#define STR_RESIDUAL_TABLE _L("Residual")

//------ Folger 03/19/08 QA80-10598 NEW_GETN_LOCALIZAED_CHECK_MACRO
#define STR_ANOVA_TABLE_E			"ANOVA"
//------

/// Iris 9/10/04 get values from one string and check its range used for percent
/**$
*/
bool 	get_tokens_check_range(string& str, vector& vVals, char chDelimiter = ' ', double dFrom = 0, double dTo = 100, bool bRemoveDup = true);

/**$
*/
string 	rollback_string_tokens(vector& vVals, char chDelimiter = ' ');
/**$
*/
string 	rollback_string_tokens(StringArray& saVals, char chDelimiter = ' ');



///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
// enum { UNDEF_FOLDER=-1, SYS_FOLDER=0, USER_FOLDER, ALL_USER_FOLDER }; //-- UNDEF_FOLDER=-1 because old codes may use -1 explicitly. Once replaced with UNDEF_FOLDER, can remove assignment in enum.
#define UNDEF_FOLDER 			ORIGIN_PATH_UNDEF
#define SYS_FOLDER 				ORIGIN_PATH_SYSTEM
#define USER_FOLDER 			ORIGIN_PATH_USER
#define ALL_USER_FOLDER 		ORIGIN_PATH_GROUP

/// DSC 3/7/05 v8.0201 MOVE_TO_OKUTIL
/* moved to okutil
#define STR_PREFIX_SYSTEM 			get_origin_path_keyword(ORIGIN_PATH_SYSTEM)
#define STR_PREFIX_ALL_USER 		get_origin_path_keyword(ORIGIN_PATH_GROUP)
#define STR_PREFIX_USER				get_origin_path_keyword(ORIGIN_PATH_USER)
#define STR_PREFIX_NAME_SEP			": " // separator between prefix and name is Colon + space
#define STR_PREFIX_SYSTEM_SEP 		get_origin_path_keyword(ORIGIN_PATH_SYSTEM, STR_PREFIX_NAME_SEP)
#define STR_PREFIX_ALL_USER_SEP 	get_origin_path_keyword(ORIGIN_PATH_GROUP, STR_PREFIX_NAME_SEP)
#define STR_PREFIX_USER_SEP			get_origin_path_keyword(ORIGIN_PATH_USER, STR_PREFIX_NAME_SEP)

///end USE_ENUM_ORIGIN_PATH_TYPE

#define STR_SYS_FDF_PREFIX				STR_PREFIX_SYSTEM_SEP
#define STR_ALL_USER_FDF_PREFIX			STR_PREFIX_ALL_USER_SEP	
#define STR_USER_FDF_PREFIX				STR_PREFIX_USER_SEP	
*/
///end MOVE_TO_OKUTIL
///end CENTRALIZE_PATH_PREFIX_CODES

//-----

/// ML 11/11/2004 QA70-6845 CELL_VALUE_LINKING
/**$
*/
void	build_report_nodes_link_string(string &str, int *pnArrIDs, int nCount);
/// end CELL_VALUE_LINKING

/**$
*/
//string get_show_books_in_project(string& strExclude = NULL);  ///Iris 4/16/05 EXISTING_BOOK_NEED_INCLUDE_HIDDEN_BOOK

/**$
*/
/// EJP 2005-04-15 v8.0223 CLEAN_ACTIVE_IMPLEMENTATION
///	int cvt_str_to_predefined_type(const string& str);
int cvt_str_to_predefined_type(LPCSTR lpcsz);
/// end CLEAN_ACTIVE_IMPLEMENTATION

///Danice TREE_ROW_SHOW_ALTERNATE_COLORS
//strActiveObjectColors : colorMain | colorInput | colorOutput
//Commetnts last updated by Frank on 1/11/05
/**$
		find the correct range column range, row range, worksheet , range name out.
	Parameters:
		strColors = [output] Colors of GetN branch show.
		strSpecialIndicatorColors =[output]Colors.
		strActiveObjectColors =[output]Colors.
	Example1:
		#include <getnbox.h>
		void get_analysis_gui_color_ex1()
		{	
			GETN_OPERATION(trGUI)
			GETN_OPTION_GRIDLINE(flexGridFlatVert)
			GETN_OPTION_EDIT_ALIGN("0|0|0")
			GETN_CHECK(AutoUpdate,_L("Auto Update"), true)	GETN_ID(IDE_AUTO_UPDATE)
   			GETN_CHECK(FitAllCurves, "Fit All Curves", 0)
   
   			GETN_BEGIN_BRANCH(Fit, "Fitting Options")//Match GETN_END_BRANCH
       			GETN_CHECK(FixIntercept, "Fix Intercept", 0)
       			GETN_CHECK(FixSlope, "Fix Slope", 0)
   			GETN_END_BRANCH(Fit)	//Match GETN_BEGIN_BRANCH
			GETN_STR(readOnly, "Testing item: ReadOnly", "Cann't modify")
   			GETN_READ_ONLY

   			GETN_NUM(Points, "Points", 20)
   
			
			string strColors, strSpecialIndicatorColors;
			get_analysis_gui_color(strColors, strSpecialIndicatorColors);
			trGUI.SetAttribute(STR_ATTRIB_TREE_ROW_COLOR, strColors);
			trGUI.SetAttribute(STR_ATTRIB_TREE_INDICATOR_COLOR, strSpecialIndicatorColors);
			if( GetNBox( trGUI ))
				return;
		}
	Return:
		Return true if get it.
*/
void get_analysis_gui_color(string &strColors, string &strSpecialIndicatorColors, string &strActiveObjectColors=NULL);
///end

#define BUILD_IN_ADVANCED_IDS_THEME_FILENAME	"AdvancedIDs"
/**$
*/
void update_param_tree_advanced_ids(TreeNode& trParam, bool bShow = false);
/// Iris 6/09/05 CHECK_PRO_ID_WHEN_CHECK_ADVANCE_ID
//#define STR_ATTRIB_ISPRO	"IsPro"   /// Iris 6/02/05 UPDATE_PRO_ID_SETTING
//void update_param_tree_for_pro_ids(TreeNode& trParam, bool bIsPro = true);
///end CHECK_PRO_ID_WHEN_CHECK_ADVANCE_ID

/**#
	iBeginRow = 0 and iEndRow = -1 will select whole col
*/
string make_range_string(const Datasheet& ds, LPCSTR lpcstrColName1, LPCSTR lpcstrColName2 = NULL, int iBeginRow = 0, int iEndRow = -1);
/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//string make_range_string(const Column& col, int iBeginRow = -1, int iEndRow = -1);
/// end XVARIABLEBASE_TO_VC

//------- CPY 9/21/04 THEME_FILE_USER_PATH_SYSTEM_PATH
/**#
*/
bool	get_operation_GUI_tree(LPCSTR lpcszClassName, Tree& trOpGUI, bool bLoadCurrentTheme = false, int nOption = 0, bool bInitData = false);
//-------

//create input data tree from worksheet and X,Y,Err column name
/**#
*/
bool make_input_data(TreeNode& trInputData, const Worksheet& wks, int nColX, int nColY, int nColYErr = -1);
///End MAKE_INPUT_DATA_FROM_WORKSHEET

/// YuI 04/06/06 BETTER_XFUNCTION_ERROR_HANDLING
/**#
*/
bool make_input_data(TreeNode& trInputData, LPCSTR lpcszRange);
/// end BETTER_XFUNCTION_ERROR_HANDLING

//---- CPY 2/17/04 XF_RELATED_TO_PATH
#define STR_XF_FILE_EXT		".OXF"
/// TD 9-12-05 QA70-7403 CODEBUILDER_XFN_INTERACTION_TO_VC
//#define STR_XF_FILE_FOLDER	"X-Functions"
/// end CODEBUILDER_XFN_INTERACTION_TO_VC

//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:xf_find_file_(global_function)
*/
int xf_find_file(string& strFilePath, LPCSTR lpcszFunctionName, LPCSTR lpcszCategoryName = NULL, int nFolderLocation = -1);
//---- end CPY 2/17/04 XF_RELATED_TO_PATH

#define PARSE_TOO_MANY_ENTRIES -1
#define PARSE_VARNAME_NOT_FOUND -2
#define PARSE_SPACE_AFTER_DASH -3
#define PARSE_BAD_ARG_ORDER	-4

/**#
*/
//int parse_arg_str(LPCSTR lpcszArg, vector<string>& vsVals, vector<string>& vsKeys, bool bKeyPartialMatch = true, bool bKeyCaseSensitive=false, StringArray* pvsKeysSet=NULL);
int parse_arg_str(LPCSTR lpcszArg, StringArray* pvsVals, StringArray* pvsKeys, bool bKeyPartialMatch = true, bool bKeyCaseSensitive=false, StringArray* pvsKeysSet=NULL);

/**#
*/
///DSC 8/18/05 AUTOCOMPLETE_XF_CMD_LINE_ARGUMENTS
int get_remaining_xf_arg_list(StringArray* p_saRemainingArgList, LPCSTR lpcszCmdLineSoFar);
///end AUTOCOMPLETE_XF_CMD_LINE_ARGUMENTS


///DSC 6/29/05 QA70-7518 LISTXF_OXF
// //int list_x_functions(LPCSTR lpcszName, LPCSTR lpcszOptions);
// int list_x_functions(LPCSTR lpcszName, LPCSTR lpcszOptions=NULL, LPCSTR lpszCategory=NULL, int nLocation=ORIGIN_PATH_UNDEF);
#define LXF_FROM_XF_LC 0x1
#define LXF_NO_LT_CHECK 0x2
/// DSC 2/27/06 ADD_OUTPUT_OPTION_TO_LIST_XF
/// DSC 2/14/06 QA70-7518 ALLOW_SEARCH_XF_BY_KEYWORDS
/**#
*/
// int list_x_functions(LPCSTR lpcszName, LPCSTR lpcszOptions=NULL, LPCSTR lpszCategory=NULL, int nLocation=ORIGIN_PATH_UNDEF, DWORD dwCtrl=0x0);
// int list_x_functions(LPCSTR lpcszName, LPCSTR lpcszOptions=NULL, LPCSTR lpszCategory=NULL, int nLocation=ORIGIN_PATH_UNDEF, DWORD dwCtrl=0x0, LPCSTR lpcszKeywords=NULL);
int list_x_functions(LPCSTR lpcszName, LPCSTR lpcszOptions=NULL, LPCSTR lpszCategory=NULL, int nLocation=ORIGIN_PATH_UNDEF, DWORD dwCtrl=0x0, LPCSTR lpcszKeywords=NULL, StringArray* p_saOutput=NULL);
/// end ALLOW_SEARCH_XF_BY_KEYWORDS
/// end ADD_OUTPUT_OPTION_TO_LIST_XF
///end LISTXF_OXF

/**#
*/
void xf_filter_names(const vector<string>& vsNames, const vector<string>& vsFiles, int nDataID,  vector<string>& vsResultNames, vector<uint>& vnOldIndices = NULL);

/**#
*/
///------ Folger 12/11/09 QA81-14831-P2 OPEN_XF_DIALOG_FROM_LT_SUPPRESS_ERROR_WHEN_USER_CANCEL
//BOOL CallXFunction(LPCSTR lpcszOxfName, LPCSTR lpcszArgs = NULL, DWORD dwControl = 0, int nParam = 0, LPVOID lpRetData = NULL, int nXVT = XVT_INT);
BOOL CallXFunction(LPCSTR lpcszOxfName, LPCSTR lpcszArgs = NULL, DWORD dwControl = 0, int nParam = 0, LPVOID lpRetData = NULL, int nXVT = XVT_INT, int* pnExecuteErr = NULL);
///------ End OPEN_XF_DIALOG_FROM_LT_SUPPRESS_ERROR_WHEN_USER_CANCEL


/**#
*/
/// YuI 07/29/05 QA70-7953 XF_THEME_SUPPORT
/// YuI 08/19/05 EXECUTE_LABTALK_WITH_STRING_ARRAY
//	BOOL 	CallXFunctionEx(LPCSTR lpcszOxfName, LPCSTR lpcszArgs = NULL, DWORD dwControl = 0, int nParam = 0, LPVOID lpRetData = NULL, int nXVT = XVT_INT, LPCSTR lpcszTheme = NULL);
///------ Folger 12/11/09 QA81-14831-P2 OPEN_XF_DIALOG_FROM_LT_SUPPRESS_ERROR_WHEN_USER_CANCEL
//BOOL 	CallXFunctionEx(LPCSTR lpcszOxfName, LPCSTR lpcszArgs = NULL, DWORD dwControl = 0, int nParam = 0, LPVOID lpRetData = NULL, int nXVT = XVT_INT, LPCSTR lpcszTheme = NULL, vector<string>* pvVarValues = NULL);
BOOL 	CallXFunctionEx(LPCSTR lpcszOxfName, LPCSTR lpcszArgs = NULL, DWORD dwControl = 0, int nParam = 0, LPVOID lpRetData = NULL, int nXVT = XVT_INT, LPCSTR lpcszTheme = NULL, vector<string>* pvVarValues = NULL, int* pnExecuteErr = NULL);
///------ End OPEN_XF_DIALOG_FROM_LT_SUPPRESS_ERROR_WHEN_USER_CANCEL
/// end EXECUTE_LABTALK_WITH_STRING_ARRAY
/// end XF_THEME_SUPPORT

/**#
*/
string get_reg_key_name(int nEventID);




/**#
*/
///Iris 6/06/05 CENTRALIZE_GUI_STRUCTURE
string 	  op_get_graph_tag_name(int nIndex = 0);

/**#
*/
TreeNode  op_get_optional_tables(TreeNode& trGUI);
///end CENTRALIZE_GUI_STRUCTURE

/**#
*/
///Joe 8/28/06  MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION
TreeNode op_get_calibration_table(TreeNode& trGUI);
///End MOVE_GET_X_FROM_Y_OR_GET_Y_FROM_X_TO_CALIBRATION


//---- CPY 5/4/2006 MOVE_XF_ERR_TO_THROW_MACRO
//void xf_error_out(string strErr);
//----

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
/*
// error codes
enum {
	XF_COMMON_ERR_BEGIN = 1000,
	
	MATOBJ_COPY_FAILED, 
	INTOPTN_OUT_OF_RANGE,
	MATOBJ_FAILED_LT_BMP,
	
	//---- CPY 10/5/05 QA70-8154 XF_AUTO_CREATE_DATA
	// global throw err msg
	XFERR_UI_USER_CANCEL = 4000,
	XFERR_INVALID_ARG,
	
	//----
	XF_COMMON_ERR_END
};
*/
/// end XVARIABLEBASE_TO_VC

/**#
		output error message in the special window
	Parameters
		nErr = [input] Error message index
		nOutputWnd = [input] The window output error message to
	Return:
		false
*/
bool xf_err(int nErr, int nOutputWnd = -1);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:vec_is_equal_(global_function)
*/
bool vec_is_equal(const vector& vIn);		

/**#
		Remove all missing values from vector and get the number of missing values.
	Parameters:
		vIn = [ input/output ] input vector		
	Return:
		Number of missing values in vector
		
*/
int vec_trim_missing(vector& vIn);		


/**#
		Check if two worksheet are the same, or on same workbook
	Parameters:
		wks1 = [input] input worksheet1
		wks2 = [input] input worksheet2
	Return:
		integer to indicats of 2 worksheets status.
		DIFF_WKB: 2 worksheet are in different workbook and different worksheet
		DIFF_WKS: 2 worksheet are in same workbook but different worksheet
		SAME_WKS: 2 worksheet are in same workbook and same worksheet			
*/
int check_same_worksheet(Worksheet& wks1, Worksheet& wks2);

///------ Folger 01/04/09 QA80-12962 MORE_WORK_ON_GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
/// move from PeakFitHelper.h
#define		FITCURVE_POINTS_PER_PEAK		30				///Jasmine 02/01/08 FITCURVE_POINTS_PER_PEAR
#define		FITCURVE_POINTS_FOR_INDIVIDUAL_PEAKS	100
///------ End MORE_WORK_ON_GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA

///------ Folger 01/04/09 QA80-12962 GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
typedef struct tagSmartXOnPeakShapeOption
{
	uint	nPts;
	//int		nPeaks;
	double	x0;
	double	w;
	int		nFuncForm;
}SmartXOnPeakShapeOption;
///------ End GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA

/**#
	get fitting data according to fitting options
	Parameters:
		vData = [input] fitting source data
		vFit = [output] the output data
		fitOptions = [input]fitting options
		pdAxisMin = [input] optional, if select SpanAxis, get minimum value of axis from it
		pdAxisMax = [input] optional, if select SpanAxis, get maximum value of axis from it
		bSortFitData = [input] if get use source data, then sort it first
		bSetCustomInput = [input] if allow vFit to set as custom type, if false, always set same as
								  input data.
*/
///Arvin 04/12/07 v8.0599 PREVIEW_RANGE_SHOULD_BE_SOUCE_GRAPH_OR_DATA_RANGE_WHEN_RANGE_TYPE_IS_SPAN_TO_FULL_AXIS_RANGE by cp's suggestion
//bool get_data_by_fitted_curve_options(const vector& vData, vector& vFit, const FitResultCurveDataOptions& fitOptions, const GraphLayer& gl = NULL, bool bSortFitData = true, bool bSetCustomInput = true);
///Kyle 11/18/2008 QA80-12591 ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
//bool get_data_by_fitted_curve_options(const vector& vData, vector& vFit, const FitResultCurveDataOptions& fitOptions, const GraphLayer& gl = NULL, double* pdAxisMin = NULL, double* pdAxisMax = NULL, bool bSortFitData = true, bool bSetCustomInput = true);
///------ Folger 01/04/09 QA80-12962 GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
//bool get_data_by_fitted_curve_options(const vector& vData, vector& vFit, const FitResultCurveDataOptions& fitOptions, const GraphLayer& gl = NULL, bool bIsX = true, double* pdAxisMin = NULL, double* pdAxisMax = NULL, bool bSortFitData = true, bool bSetCustomInput = true);
bool get_data_by_fitted_curve_options(const vector& vData, vector& vFit, const FitResultCurveDataOptions& fitOptions, const GraphLayer& gl = NULL, bool bIsX = true, double* pdAxisMin = NULL, double* pdAxisMax = NULL, bool bSortFitData = true, bool bSetCustomInput = true, SmartXOnPeakShapeOption* pSmartXOpt = NULL);
///------ End GENERATE_INDIVIDUAL_FIT_CURVE_USING_INDEPENDENT_X_IN_PA
///End ADD_MORE_OPTION_FOR_INPUT_DATA_TYPE_IN_FITTING_TOOLS
///end PREVIEW_RANGE_SHOULD_BE_SOUCE_GRAPH_OR_DATA_RANGE_WHEN_RANGE_TYPE_IS_SPAN_TO_FULL_AXIS_RANGE
//#define 	STR_M2W_WKS_LONGNAME_PRE 			"Converted From"	///Leo 2005-12-22 NOT_USED!

///Echo 6/23/06 moved to event_utils.c 
///**
		//event for sample size/power functions
	//Parameters:
		//tr = [input] treenode of sample size/power function
//*/
//bool samplesize_event(TreeNode tr);


/// YuI 08/23/05 XF_MATRIX_OBJECT_CENTRALIZED_DATA_CONVERSION
/**#
*/
bool	check_matrix_has_data(MatrixObject& mObj, BOOL bOfferConversion = true);
/// end XF_MATRIX_OBJECT_CENTRALIZED_DATA_CONVERSION

///Kevin 08/29/05	ADD_VECTOR_TO_STRING
/**#
*/
int vector_to_str_list(const vector &vec, string &strList, bool bSort = true, bool bRemoveRepeat = true, char chSeparator = '|');
/// End ADD_VECTOR_TO_STRING


/// ML 1/13/2006 XVARIABLEBASE_TO_VC
//enum {CCS_ERR_LTVAR_NOT_FOUND = -1, CCS_NO_CHANGE, CCS_NO_CHANGE_GOOD_C_NAME, CCS_QUOTE_REMOVED, CCS_LTVAR_SUBSTITUDED};
///**$
//return CCS_LTVAR_SUBSTITUDED if LT str variable and converted
//return CCS_QUOTE_REMOVED if quoted and quotes removed
//return CCS_ERR_LTVAR_NOT_FOUND if $ ended but not found to be LT str variable
//return CCS_NO_CHANGE if no change, either because not ended with $ and bCheckLTstrVarOnlyIfDollarEnded=false, or bCheckLTstrVarOnlyIfDollarEnded but not ended with $ and not a LT str variable
//*/
//int check_cvt_str(const string& strVal, string& str, bool bCheckLTstrVarOnlyIfDollarEnded = true);
/// end XVARIABLEBASE_TO_VC

/// ML 1/13/2006 XVARIABLEBASE_TO_VC
///// YuI 10/10/05 QA70-8158 GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
//#define XF_VARIABLE_ASSIGNMENT_STR ":="
///// end GENERAL_X_STRING_CONVENTION_TO_ACCESS_OBJECTS
/// end XVARIABLEBASE_TO_VC
///----Frank 11/23/05 ADD_NOISE_AND_SAVE_DATA

/**#
*/
/// Cloud 8/30/07 ADD_OPTION_OF_NOISE
enum {
	NOISE_OVER_AVERAGE,
	NOISE_OVER_DIFFERENCE
};
//void add_white_noise(vector& vSignal, double level);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:add_white_noise_(global_function)
*/
void add_white_noise(vector& vSignal, double level, int type=NOISE_OVER_AVERAGE);
/// End ADD_OPTION_OF_NOISE

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:save_data_2_Wks_(global_function)
*/
void save_data_2_Wks(Worksheet& wks, vector& vX, vector& vY, vector& vZ = NULL);
///----End ADD_NOISE_AND_SAVE_DATA


//---- CPY 12/12/05 NLF_FUNCTIONS_NEEDED_IN_PCH
//-----------------------------------------------------------
// the following nlf functions are needed in various PCH and
// must be compiled into Origin.h
//-----------------------------------------------------------
//Commetnts last updated by Frank on 1/11/05
/**$
		find the FDF file
	Parameters:
		lpcszFuncName = [input] Function name.
		lpstrCategory =[input/output] If NULL, will seacher in all category.
		pnFolder =[output] If not NULL, will storage the function file folder.
		strFullpathFDFfile =[output] If not NULL, will storage the function full path.
	Example1:
		void nlf_get_fdf_filename_ex1()
		{	
			string strFullPath;
			if(nlf_get_fdf_filename( "Sine", NULL, NULL, &strFullPath))
				out_str(strFullPath);
			else
				out_str("No FDF found, or not defined in nlsf.ini");
		}
	Return:
		Return true for success
*/
bool nlf_get_fdf_filename(LPCSTR lpcszFuncName, string* lpstrCategory = NULL, int* pnFolder=NULL, string* strFullpathFDFfile = NULL);


/**$
		find the correct range column range, row range, worksheet , range name out.
	Parameters:
		nIniPath =[input] ini file folder, user folder, all user folder, system folder.
		bAddNLSFini =[input]If yes, add nlsf prefix.
	Example1:
		void nlf_get_ini_filepath_ex1()
		{	
			string strFunction;
			strFunction = nlf_get_ini_filepath( ORIGIN_PATH_USER);
		}
	Return:
		Return string of ini file path if get it.
*/
string nlf_get_ini_filepath(int nIniPath = ORIGIN_PATH_USER, bool bAddNLSFini = true);

//----- end CPY 12/12/05 NLF_FUNCTIONS_NEEDED_IN_PCH

///Arvin 07/06/07 v8.0654 NEED_USE_THIS_FUNCTION_IN_FITNL
//static bool nlf_find_category(LPCSTR lpcszFunc, string& strCategory, int& nFolderLocation)
bool nlf_find_category(LPCSTR lpcszFunc, string& strCategory, int& nFolderLocation);
///END NEED_USE_THIS_FUNCTION_IN_FITNL

///Echo 1/5/05 STR_GROUP_TO_NUM
/**#
		Transfer group in string to num
	Parameters:
		vstrGroup =[input] Input group in string
		vGroup =[output] Transfered group in num
		vstrLab = [output] Labels of each group
		vNumInGroup = [output] numbers of each group
*/
bool get_group(vector<string> &vstrGroup, vector &vGroup, vector<string> &vstrLab = NULL, vector& vNumInGroup = NULL);

///end STR_GROUP_TO_NUM

///Echo 1/5/05 TRIM_DULP_IN_VEC
/**#
		Trim all duplicated values in vector
*/
void trim_duplicated_value(vector& vData, vector& vNoDuplic);
///end TRIM_DULP_IN_VEC

/// Iris 2/06/06 QA70-8388 INDEP_DATA_CONSOLID_OR_SEP_REPORT
/**#
		To get the input data range number for operation based tools
*/
int		op_get_input_data_number(TreeNode& trGUI, DWORD dwRules);
/// End INDEP_DATA_CONSOLID_OR_SEP_REPORT

///Echo 3/13/06 GET_COL_NAME_FROM_RANGE
/**#
	To get i-th column of data range
*/
bool range_get_col(const DataRange& dr, const int nIndex, Column& col, int* nRowBegin = NULL, int* nRowEnd = NULL);

/**#
	To get i-th column name of data range
*/
///------ Folger 12/18/08 QA80-12642 v8.0988 SUPPORT_MAKE_COLUMN_NAME_WITH_LN_ONLY
//string range_get_col_name(const DataRange& dr, const int nIndex = 0);
string range_get_col_name(const DataRange& dr, const int nIndex = 0, BOOL bLongNameOnlyIfExist = FALSE);
///------ End SUPPORT_MAKE_COLUMN_NAME_WITH_LN_ONLY

/**#
	To datatype of i-th column of data range
*/
int range_get_col_type(const DataRange& dr, const int nIndex = 0);

///Arvin 11/16/06 GET_FIRST_Y_COL_FROM_RANGE
/**#
	To get first column index of data range
*/
int get_first_y_col_index(const DataRange& dr);
///end GET_FIRST_Y_COL_FROM_RANGE

///Sandy 2007-7-20 REMOVE_NO_USE
///Sandy 2006-6-7 GET_COL_ID_WITH_DIFFERENT_ID
/**$
	To get column information of data range
*/
//string range_get_col_id(const DataRange& dr, const int nIndex, const int idRule, const int nParamIndex = 0);
//end Sandy 2007-7-20 REMOVE_NO_USE

///Alex 03/27/06 QA70-8551 DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR
/**#
	To check if inlcude special subrange by range name
*/
bool 	is_include_special_subrange(const DataRange &dr, string strSubRangeName);
///End DEL_ERR_COL_IN_REPORT_TABLE_IF_NOT_INPUT_ERR


/**#
*/
bool trim_nanum_1group(vector &vData, vector<string> &vstrGroup, int& nMissing);

/**#
*/
bool trim_nanum_2group(vector &vData, vector<string> &vsGroup1, vector<string> &vsGroup2, int& nMissing);

/**#
*/
int  trim_nanum_sa(int* nMissing, vector &vTime, vector &vCensor, vector<string> &vstrGroup=NULL, matrix &mCovariat=NULL, const bool bWeibull = false);


/**#
*/
int get_data_in_group(const Range& rInGroup, vector& vData, vector& vNumInGroup, vector<string> &vstrLab = NULL);
/**#
*/
int get_anova2_data(const Range& rInGroup, vector& vData, vector& vGroup1, vector& vGroup2, vector<string> &vstrGroup1, vector<string> &vstrGroup2);

/**#
		To get 2 dataset from grouped range
	Parameter:
		rInGroup=[input]Input data range. 
		vData1=[output]1st dataset got from data range
		vData2=[output]2nd dataset got from data range
		vstrLab=[output]vector containing Label of the 2 dataset
		nMissing=[output]Number of missing values in range
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.	
*/
int get_2_data_in_group(const Range& rInGroup, vector& vData1, vector& vData2, vector<string>& vstrLab = NULL, int& nMissing = 0, const bool bPair = false);

/**#
		To get 2 dataset from data range
	Parameter:
		rInVar=[input]Input data range. 
		vData1=[output]1st dataset got from data range
		vData2=[output]2nd dataset got from data range
		vstrLab=[output]vector containing Label of the 2 dataset
		nMissing=[output]Number of missing values in range
		bPair=[input] bit to control how to trim missing value. If bPair = true, missing values will be trimmed pairwise, otherwise will be trimmed one by one. 
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.	
*/
int get_2_data_in_var(const Range& rInVar, vector& vData1, vector& vData2, vector<string>& vstrLab = NULL, int& nMissing = 0, const bool bPair = false);


/**#
		Report error in message box and return false.
	Parameters:
		lpcszErrMsg=[input] the error message
	Return:
		Always return false.	
*/
bool error_msg_box(LPCSTR lpcszErrMsg);

/**#
		Report error in message box to follow nErrCode
	Parameters:
		nErrCode=[input] the error code
	Return:
		Always return false.
*/
bool error_msg_box(int nErrCode);

///---Sim 08-22-2006 ERR_MSG_SUPPORT_PARAM
/**#
		Report error in message box to follow nErrCode
	Parameters:
		nErrCode=[input] the error code
		nParam=[input] integer parameter of error message string
	Return:
		Always return false.
*/
bool error_msg_box(int nErrCode, int nParam);

/**#
		Report error in message box to follow nErrCode
	Parameters:
		nErrCode=[input] the error code
		lpcszParam=[input] string parameter of error message string
	Return:
		Always return false.
*/
bool error_msg_box(int nErrCode, LPCSTR lpcszParam);

/**#
		Report error in message box to follow nErrCode
	Parameters:
		nErrCode=[input] the error code
		nParam=[input] integer parameter of error message string
		lpcszParam=[input] string parameter of error message string
	Return:
		Always return false.
*/
bool error_msg_box(int nErrCode, int nParam, LPCSTR lpcszParam);

/**#
		Report error in message box to follow nErrCode
	Parameters:
		nErrCode=[input] the error code
		lpcszParam=[input] string parameter of error message string
		nParam=[input] integer parameter of error message string
	Return:
		Always return false.
*/
bool error_msg_box(int nErrCode, LPCSTR lpcszParam, int nParam);
///---END ERR_WARNING_MSG_SUPPORT_PARAM

///---Sim 06-19-2007 IMPROVE_WARNING_MESSAGE_POST_FUNCTION
///---Sim 08-23-2006 WARNING_MSG_BOX
/**#
		Report warning in message box to follow nErrCode or lpcszErrMsg
	Parameters:
		nErrCode=[input] the error code
		lpcszErrMsg=[input] the error message
		nParam=[input] integer parameter of error message string
		lpcszParam=[input] string parameter of error message string
		bShowBox =[input] Show message dialog box
		cMsgType = [input] controlled by @NOW, @NOI, @NOE system variables
			 'W' for warning message, default = OUTMSG_CB_CMD_OUT
			 'I' for info message, default = OUTMSG_SCRIPT_WIN
			 'E' for error message, default = OUTMSG_SCRIPT_WIN_FORCE_OPEN
			 
			 if bShowBox is true, this parameter will be ignored
		uType = [input]Constants describing the characteristics of the message box. One constant from each group below
			can be combined using the bitwise OR operator "|", default is MB_OK
		
			Buttons on message box:			MB_OK, MB_OKCANCEL, MB_ABORTRETRYIGNORE, MB_YESNOCANCEL, MB_YESNO,
											MB_RETRYCANCEL
			Icon on message box:			MB_ICONHAND, MB_ICONQUESTION, MB_ICONEXCLAMATION, MB_ICONASTERISK,
											MB_ICONINFORMATION, MB_ICONSTOP		
			Default button of message box:	MB_DEFBUTTON1, MB_DEFBUTTON2, MB_DEFBUTTON3
			Modality of message box:		MB_APPLMODAL, MB_SYSTEMMODAL, MB_TASKMODAL
			Mask of message box:			MB_TYPEMASK, MB_ICONMASK, MB_DEFMASK, MB_MODEMASK, MB_MISCMASK
			
			if bShowBox is false, this parameter will be ignored
		
		If bShowBox is false, then no dialog and just printf,
		else will show MessageBox, return value will be IDOK or IDCANCEL.
		nErrCode < 0 means to use lpcszErrMsg directly, user must provide lpcszErrMsg if nErrCode < 0.
		lpcszParam = NULL if not used, nParam = XFERR_NAPARAM_UNUSED if not used.
	Return:
		User click "OK", return IDOK
		User click "Cancel", return IDCANCEL
		No dialog, return 0.
*/
//int show_warning_msg(int nErrCode, LPCSTR lpcszErrMsg, int nParam, LPCSTR lpcszParam, bool bOKButton, bool bCancelButton, bool bIcon);
int show_warning_msg(int nErrCode, LPCSTR lpcszErrMsg, int nParam, LPCSTR lpcszParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(LPCSTR lpcszErrMsg, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(LPCSTR lpcszErrMsg, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(LPCSTR lpcszErrMsg, int nParam, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(LPCSTR lpcszErrMsg, int nParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(int nErrCode, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(int nErrCode, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(int nErrCode, int nParam, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(int nErrCode, int nParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(int nErrCode, LPCSTR lpcszParam, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(int nErrCode, LPCSTR lpcszParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(int nErrCode, int nParam, LPCSTR lpcszParam, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(int nErrCode, int nParam, LPCSTR lpcszParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:warning_msg_box_(global_function)
*/
//int warning_msg_box(int nErrCode, LPCSTR lpcszParam, int nParam, bool bShowBox, bool bCancelButton=FALSE, bool bIcon=TRUE);
int warning_msg_box(int nErrCode, LPCSTR lpcszParam, int nParam, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);
///---END WARNING_MSG_BOX
///---END IMPROVE_WARNING_MESSAGE_POST_FUNCTION

//------ Folger 08/29/08 QA80-12120 CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE
/**$
*/
string	xf_load_err_msg(int nErrCode, LPCSTR lpcsz);

/**#
		General error message output mechanism for X-Function before execute.
	Also can use for more general case that needs to output error message.

	Parameters:
		lpcszErrMsg=[input]Can be any simple string or string contains error code and optional format arguments
		bShowBox=[input]True to show message box
		cMsgType=[input]Can be 'I'(info), 'W'(warning), 'E'(error)
		uType=[input]Constants describing the characteristics of the message box. One constant from each group below
			can be combined using the bitwise OR operator "|", default is MB_OK

	Return:
		return as MessageBox
		No dialog, return 0.
*/
int		xf_warning_msg_box(LPCSTR lpcszErrMsg, bool bShowBox, char cMsgType = 'W', UINT uType = MB_OK);
//------ End CENTRALIZE_XF_ERROR_MSEEAGE_PARSING_CODE

//------- CPY 7/5/06 QA70-8798 ON_OK_EVENT_TO_ALLOW_XF_HANDLING
/**$
*/
//int get_input_data_size(TreeNode& trInputData);
int get_input_xyrange_data_size(TreeNode& trInputData);	/// Max 11/25/06 RENAME_TO_GET_INPUT_XYRANGE_DATA_SIZE
//-------
///------ Folger 08/02/10 ORG-672 INTEG1_SUPPORT_MULTIPLE_XYRANGES
int get_input_xyrange_data_size(XYRange& xy);
///------ End INTEG1_SUPPORT_MULTIPLE_XYRANGES

/// ML 11/10/2008 QA70-12356 RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES
///// YuI 06/12/07 QA70-9913 XYRNAGE_EVEN_SAMPLING_PROPER_SUPPORT
//BOOL	set_xyrange_data_ex(XYRange& dr, vector* pY, vector* pX, int nIndex = 0, XYRange& drReference = NULL);
///// end XYRNAGE_EVEN_SAMPLING_PROPER_SUPPORT
/// YuI 10/13/09 QA70-14023 OPTION_TO_FORCE_SAMPLING_INTERVAL_RECALCULATION
//	BOOL	set_xyrange_data_ex(XYRange& dr, vector* pY, vector* pX, int nIndex = 0, XYRange& drReference = NULL, vector<int> *pvnMissingValsIndices = NULL);
typedef enum tagSETXYDATACNTRL
{
	SXYDC_RECALCULATE_SAMPLING_INTERVAL = 0x00000001,
}	SETXYDATACNTRL;
BOOL	set_xyrange_data_ex(XYRange& dr, vector* pY, vector* pX, int nIndex = 0, XYRange& drReference = NULL, vector<int> *pvnMissingValsIndices = NULL, DWORD dwCntrl = 0);
/// end OPTION_TO_FORCE_SAMPLING_INTERVAL_RECALCULATION
/// end RANGE_GET_DATA_PROVIDE_MAP_OF_MISSING_VALUES

//------ Folger 09/25/08 QA80-12276 SET_SAMPLING_INTERVAL_FOR_YXRANGE_OUTPUT
/// YuI 10/13/09 QA70-14023 OPTION_TO_FORCE_SAMPLING_INTERVAL_RECALCULATION
//	BOOL	update_output_xyrange_even_sampling(XYRange& dr, vector* pX, int nIndex = 0, XYRange& drReference = NULL);
BOOL	update_output_xyrange_even_sampling(XYRange& dr, vector* pX, int nIndex = 0, XYRange& drReference = NULL, DWORD dwCntrl = 0);
/// end OPTION_TO_FORCE_SAMPLING_INTERVAL_RECALCULATION
//------

/**#
		Get the numeric string list from nMin to nMax with nInc
	Parameters:
		vsList=[output] string list vecotr
		nMax=[input] the data that list to
		nMin=[input] the data that list from
		nInc=[input] increase value for one step
	Return:
		Return true if no error in input variables.	
*/
bool	str_data_list(vector<string>& vsList, int nMax, int nMin = 1, int nInc = 1);

///Arvin 9/01/06 ADD_WKS_IS_ALL_COLS_DOUBLE
/**#
		Checks whether all columns internal data types are double or not
	Parameters:
		wks=[input] worksheet
	Return:
		Return true on yes, false on not.
*/
bool  	wks_is_all_cols_double(const Worksheet& wks);
///end ADD_WKS_IS_ALL_COLS_DOUBLE

///Arvin 9/28/06 ADD_WKS_HAS_TEXT_COL
/**#
		Checks whether worksheet has text column 
	Parameters:
		wks=[input] worksheet
	Return:
		Return true on yes, false on not.
*/
bool  	wks_has_text_col(const Worksheet& wks);
///END ADD_WKS_HAS_TEXT_COL

///Arvin 9/29/06 ADD_WKS_HAS_COMPLEX_COL
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wks_has_complex_col_(global_function)
*/
bool wks_has_complex_col(const Worksheet& wks);
///end ADD_WKS_HAS_COMPLEX_COL

/**#
*/
///Joseph  10/9/06	SEPERATE_DESCIPTION_OR_COMBINE_DESCRIPTION_SECTION 
void	xf_seperate_description(LPCSTR lpcszDesp, string& strMenu, string& strBriefDesp);

/**#
*/
void 	xf_combine_description_section( LPCSTR lpcszMenu, LPCSTR lpcszBriefDesp, string& strDescriptoin);
///End SEPERATE_DESCIPTION_OR_COMBINE_DESCRIPTION_SECTION

///Cheney 2006-10-11 GET_DATA_FROM_DR_TO_MAT, need to move to VC later.
//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_column_in_bounds_(global_function)
*/
bool is_column_in_bounds(int nCol, vector<int>& vColLower, vector<int>& vColUpper);

/// Iris 3/16/2010 QA81-10824 TRIM_UNUSEFUL_MISSING_DATA_IN_OUTPUT_COLUMNS
enum
{
	MATRIX_FROM_RANGE_NOT_REMOVE_MISSING = 0,
	MATRIX_FROM_RANGE_REMOVE_ALL_MISSING_ROWS,
	MATRIX_FROM_RANGE_REMOVE_MISSING_FROM_LAST_SEL_ROW
};
///End TRIM_UNUSEFUL_MISSING_DATA_IN_OUTPUT_COLUMNS

//Comments last updated by Sim on 12-05-2007
//Commetnts last updated by Cheney on 2007.4.13
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:get_data_from_dr_to_mat_(global_function)
*/
///---Sim 12-05-2007 REWRITE_WKS_DATA_RANGE_TO_MAT
//bool get_data_from_dr_to_mat(const DataRange& dr, matrixbase& mat);
/// Iris 2/24/2010 QA81-10824 TRIM_UNUSEFUL_MISSING_DATA_IN_OUTPUT_COLUMNS
//bool get_data_from_dr_to_mat(const DataRange& dr, matrixbase& mat, bool bRemoveMissingRows = true, bool bRemoveMissingCols = true);
bool get_data_from_dr_to_mat(const DataRange& dr, matrixbase& mat, int nRemoveMissingRows = MATRIX_FROM_RANGE_REMOVE_ALL_MISSING_ROWS, bool bRemoveMissingCols = true);
///End TRIM_UNUSEFUL_MISSING_DATA_IN_OUTPUT_COLUMNS
///---END REWRITE_WKS_DATA_RANGE_TO_MAT no useful

/**$
	Remarks:
		when ctrl select data, there will be many subranges. use GetSelectRange you can get 4
		Index vectors: r1, c1, r2, c2. but they can not show those subranges bounds.
		for example: r1 = {9, 0, 10, 7}; r2 = {10, 5, 15, 9}. it is best to make those became
		{0, 7} and {5, 15}, that means those 4 subranges include 0-5 row and 7-15 row. 
		then we can get their row bounds.
		The same as columns bounds.
	Keywords:
		Subranges bounds;
	Example1:
		bool get_select_range_bounds_Ex1()
		{
			//get source worksheet
			Worksheet wks = Project.ActiveLayer();
			
			//get wks' select range
			vector<int> vr1, vc1, vr2, vc2;
			int nSubRanges = wks.GetSelectedRange(vr1, vc1, vr2, vc2);
			if(nSubRanges < 1)
				return false;
			
			//get wks' range
			int c1 = 0;
			int c2 = wks.GetNumCols() - 1;
			int r1, r2;
			wks.GetRange(r1, r2, c1, c2); 
			
			//to get subranges' bound
			vector<int> vrLower, vrUpper;
			if(!get_select_range_bounds(vr1, vr2, r2, vrLower, vrUpper))
				return false;
			
			vector<int> vcLower, vcUpper;
			if(!get_select_range_bounds(vc1, vc2, c2, vcLower, vcUpper))
				return false;
			
			return true;
		}
	Parameters:
		v1 		= [input]  subranges r1/c1 index vector.
		v2 		= [input]  subranges r2/c2 index vector.
		nBound	= [input]  number of row/col, if v2[ii] == -1, should replace it by nBound.
		vLower	= [output] subranges row/col lower bound vector.
		vUpper	= [output] subranges row/col upper bound vector.
	Return:
		Return true for success, false for failure.	
*/
bool get_select_range_bounds(vector<int>& v1, vector<int>& v2, uint nBound, vector<int>& vLower, vector<int>& vUpper);
///end GET_DATA_FROM_DR_TO_MAT

/**#
*/
///Arvin 10/17/06 ADD_IS_PERCENTILE_VALUE
int is_percentile_value(double dPercent, vector* pPercentiles = NULL);
///end ADD_IS_PERCENTILE_VALUE

///Arvin 10/19/07 USER_SETTED_PERCENTILES_SHOULD_NOT_EFFECT_HISTOGRAM_AND_BOX_CHART_GRAPHS as max said
int trim_custom_percentiles(const vector vPercents, vector& vPercentiles);
///end USER_SETTED_PERCENTILES_SHOULD_NOT_EFFECT_HISTOGRAM_AND_BOX_CHART_GRAPHS

/**#
*/
//int get_input_range_num(TreeNode& trInputData);	/// Max 11/25/06 RENAME_TO_GET_INPUT_XYRANGE_NUM
int get_input_xyrange_num(TreeNode& trInputData);

/**#
*/
/// Iris 11/13/06 DO_TWO_TIMES_SEP_REPORT_IN_NLFIT_AND_OPBASE
bool get_sub_string_vector(const vector<string>& vs, vector<string>& vsDest, int nStart, int nEnd = -1);
///end DO_TWO_TIMES_SEP_REPORT_IN_NLFIT_AND_OPBASE

//Commetnts last updated by Joseph on 2007.5.22
///---Sim 12-08-2006 GET_LARGEST_GAP
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:find_largest_gap_(global_function)
*/
int find_largest_gap(const vector& vValue);
///---END GET_LARGEST_GAP

/**#
*/
///Arvin 12/29/06 SET_W_AS_ED_OF_DATARANGE_AND_PLOT_ERROR_BAR
//The function AddPlot determines column type by tag name of corresponding subrange, when we use it 
//plot graph of a data range. But, sometimes the name is no real name of column, so in this function,
//we judge column's real type first, and create a new data range named by column's real type, and 
//then use the new created data range to plot graph.
///Cheney 2007-9-7 SHOULD_ALLOW_DUP_DATASET_PLOT_FOR_PREVIEW_SO_AS_TO_SAME_WITH_FIT_THINGS
//int plotDataRange(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL);
/// Iris 10/24/2008 v8.0960b FIX_FAIL_NOT_SETUP_PLOT_FOR_ALL_PEAK_CURVES
//int plotDataRange(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bCheckDup = true);
/// Hong 03/25/09 QA80-12551 RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
//int plotDataRange(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bCheckDup = true, vector<int> *pvnPlottedIndices = NULL);
int plotDataRange(DataRange& dr, GraphLayer& gl, int nPlotType, uint nCntrl = GAP_GROUP_PLOTS | GAP_USE_TEMPLATE | GAP_ALLOW_DUPLICATE_COL, bool bCheckDup = true, vector<int> *pvnPlottedIndices = NULL, bool bResetPlotRowRangeIfDiffButNotChecked = false);
/// end RESET_PLOT_ROW_RANGE_IF_USER_UPDATE_INPUT_DATARANGE_WHEN_CHANGE_PARAMETER
///end FIX_FAIL_NOT_SETUP_PLOT_FOR_ALL_PEAK_CURVES
///end SHOULD_ALLOW_DUP_DATASET_PLOT_FOR_PREVIEW_SO_AS_TO_SAME_WITH_FIT_THINGS
///end SET_W_AS_ED_OF_DATARANGE_AND_PLOT_ERROR_BAR

//Commetnts last updated by Joseph on 2007.5.22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:is_col_all_text_(global_function)
*/
int is_col_all_text(const Worksheet& wks, int nCol);

/// Iris 01/16/2007 v8.0542 CHANGE_GRAPH_NUM_COLS_ACCORDING_TO_NUM_DATASET
/**$
*/
/// Iris 9/10/2009 QA80-11710-P2 IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
//int		get_report_graph_num_cols(int nNumData);
int		get_report_graph_num_cols(int nNumData, int nNumFactors = 0, bool bIsPlotAllInOneGraph = false);
///end IMPROVE_REPORT_GRAPH_WHEN_PLOT_IN_ONE_GRAPH_WITH_GROUPING_DATA
///end CHANGE_GRAPH_NUM_COLS_ACCORDING_TO_NUM_DATASET

/// Cheney 2007-7-16 SHOULD_GENERATE_X_DATA_UNIFORMLY_SPACED_IN_LOG_SPACE_WHEN_LOG_TYPE 
/**$
*/
//---- CPY 10/29/2007 QA70-10599 NLFIT_PREVIEW_UPDATE_CLEANUP
//bool get_fitted_curve_min_max(double& dMin, double& dMax, double dMargin, bool bLogScale = false, int* pSteps = NULL, double* pIncre = NULL, bool bRound = true);
//---- Iris 11/20/2008 v8.0975d QA80-12591-S1 CENTRALIZE_NEW_X_DATA_TYPE_AND_LOG_TYPE_CODES
//double get_min_max_inc(double& dMin, double& dMax, bool bLogScale = false, double dMargin=0.08, int nSteps=0);
double get_min_max_inc(double& dMin, double& dMax, int nScaleType = 0, double dMargin=0.08, int nSteps=0);
//----

///Arvin 11/22/07 NEED_RESCALE_FOR_3D_FITTINGS
//bool get_data_range_xy_scale(DataRange& dr, double& x1, double& x2, double& y1, double& y2, DWORD dwRules);
bool get_data_range_xy_scale(DataRange& dr, double& x1, double& x2, double& y1, double& y2, DWORD dwRules, double* pz1 = NULL, double* pz2 = NULL);
///end NEED_RESCALE_FOR_3D_FITTINGS
//----
///end SHOULD_GENERATE_X_DATA_UNIFORMLY_SPACED_IN_LOG_SPACE_WHEN_LOG_TYPE

///Arvin 11/09/07 NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT
enum{
	RESCALE_SHOW_ALL = 0x01,
	RESCALE_SHRINK_X = 0x02,
	RESCALE_SHRINK_Y = 0x04,
};

bool is_plot_requir_rescale(DataPlot& dp, int nOption = RESCALE_SHOW_ALL);
///end NLFIT_REPORT_GRAPH_NEED_RESCALE_WHILE_PART_GRAPH_SELECTION_AS_INPUT

//----- CPY 10/12/07 10522-P3 CLEANUP_IF_LOOSE_DATASET_SHOULD_NOT_PUT_REPORT_SHEET_TO_SOURCE
//I cannot find a good place to put this as seems to be used in multiple low level places
typedef enum tagNLFITTYPE
{
	NLFIT_GENERAL_XY_FITTING,
	NLFIT_XYZ_FITTING,
	NLFIT_MATRIX_FITTING,
}tagNLFITTYPE;
//-----

///---Sim 11-05-2007 IMPROVE_LOCALIZATION_ISSUE
/**$
*/
bool compare_string_localization(LPCSTR lpszLocalDest, LPCSTR lpszEnglishSub, bool bNoCaseSensitive = false);

/**$
	See Also: String::Find()
*/
int find_string_localization(LPCSTR lpszLocalDest, LPCSTR lpszEnglishSub);
///---END IMPROVE_LOCALIZATION_ISSUE

///Arvin 11/16/07 QA70-10676 UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO
int  find_unique_values(const vector& vData, vector<int>& vUniqueIndices);
///end UPDATE_MEANS_COMPARISION_PLOT_LEGENT_WITH_SIG_INFO

/// ML 12/17/2007 INITIALIZING_PEAK_POSITIONS_FOR_REPLICAS_FITTING
/////Cheney 2007-11-20 INIT_XC_FOR_REPLICA_FITTING
////algorithm see http://wiki.originlab.com/~originla/wiki/index.php?title=Originlab:NLFit_GUI_discussion#How_should_Theme_apply_work_on_Parameters_tab_and_Bounds_tab
//bool init_xc_for_replica_fitting(const vector& vecInputx, int nReplica, vector& vXc); 
/////end INIT_XC_FOR_REPLICA_FITTING
/// Cloud 12/18/07 TREAT_SIGN_OF_PEAK_AREA
//bool init_xc_for_replica_fitting(const vector& vInputX, const vector& vInputY, int nReplica, vector& vXc, double rBaseline); 
///Arvin 03/13/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
//Move to curve_utils.h&cpp
//bool init_xc_for_replica_fitting(const vector& vInputX, const vector& vInputY, int nReplica, vector& vXc, double rBaseline, vector* pvPeaksY = NULL);
///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
/// End TREAT_SIGN_OF_PEAK_AREA
/// end INITIALIZING_PEAK_POSITIONS_FOR_REPLICAS_FITTING

//Comments last updated by Stacy on 7/23/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fitpoly_(global_function)
*/
/// Cloud 04/10/08 PASS_X_NOMALIZED_STATUS_BY_PARAMETER
//int fitpoly(int nOrder, double* pX, double* pY, int nSize, vector& vCoeff, vector& vError = NULL, RegStats* psRegStats = NULL);
int fitpoly(int nOrder, double* pX, double* pY, int nSize, vector& vCoeff, vector& vError = NULL, RegStats* psRegStats = NULL, bool* pbXNorm = NULL);
/// End PASS_X_NOMALIZED_STATUS_BY_PARAMETER

//----- CPY 2/3/2008 QA70-11050 GET_PTS_NEED_USER_DECIDE_TERMINATION
/**$ >Curve
	Ask user to click n points (-1 to indicate unknown) on the active graph
	Example:
		void graph_get_points_ex()
		{
			vector vx, vy;	
			GraphLayer gl = Project.ActiveLayer();
			if(gl && graph_get_points (vx, vy) > 0)
			{
				string strX = "tmpgetpts_a";
				string strY = "tmpgetpts_b";
				LT_execute("create tmpgetpts -wd 100 a b");
				Dataset aa(strX);
				Dataset bb(strY);
				aa = vx;
				bb = vy;
				Curve cc(strX, strY);
				gl.AddPlot(cc, IDM_PLOT_LINESYMB);
			}
			
		}
	Parameters:
		vx = [output] x coordinates picked by user
		vy = [output] y coordinates picked by user
		lpcszMsg1 = first message before user click any points, NULL will see default message to ask user to click points on the graph
		lpcszMsg2 = continuation message, NULL will reuse lpcszMsg1
		pnPlotIndex = [input] Sets/Unsets the cursor to move along a DataPlot specified by the plot index. Default NULL is unset.
		lpcszTitle = [input] title of the small dialog on the graph
		nPts = [input] number of points requested, -1 to indicate unknown
		nCursorType = [input] -1 to use default, otherwise some internally defined cursors
	Return:
	  return number of points or 0 if user had cancelled, -1 if no active graph layer or if layer in appropriate 
*/
/// Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
//int graph_get_points(vector& vx, vector& vy, int nPts = -1, int nCursorType = -1, LPCSTR lpcszMsg1=NULL, LPCSTR lpcszMsg2=NULL);
///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
//int graph_get_points(vector& vx, vector& vy, LPCSTR lpcszMsg1=NULL, LPCSTR lpcszMsg2=NULL, int* pnPlotIndex = NULL, LPCSTR lpcszTitle=NULL, int nPts = -1, int nCursorType = -1);
int graph_get_points(vector& vx, vector& vy, LPCSTR lpcszMsg1=NULL, LPCSTR lpcszMsg2=NULL, int* pnPlotIndex = NULL, LPCSTR lpcszTitle=NULL, int nPts = -1, int nCursorType = -1, vector<int>& vnDatapointIndices = NULL, bool bShowDlg = true, vector<int>& vnDataplotIndices = NULL);
///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
/// end PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
//----- end GET_PTS_NEED_USER_DECIDE_TERMINATION

/// Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
/**$
	A simple child window with done button for graph page, which will notify attached page's attach XF dialog
	with event WM_USER_ON_GRAPH_OBJECT_CHANGE when close(click done button will force window close)
	Example:
		void test_graph_done_window_ex1()
		{
			graph_done_window("Click done button to close window");
		}
	Parameters:
		dwDlg = [output] dialog pointer, to close dialog by SendMessage(WM_CLOSE)
		lpcszMsg1 = display message string, NULL to show default.
		lpcszTitle = [input] title of the small dialog on the graph
		bAutoResize = [input] true will auto resize dialog according to lpcszMsg1 length
	Return:
		true if window create successful, false otherwise.
*/
//bool graph_done_window(LPCSTR lpcstrMsg, LPCSTR lpcszTitle, BOOL bAutoResize = true);
bool graph_done_window(DWORD& dwDlg, LPCSTR lpcstrMsg, LPCSTR lpcszTitle, BOOL bAutoResize = true);
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY

///Arvin 03/11/08 REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT
typedef struct tagContourFindPeakInfo
{
	int 	_id(IDE_REPLICA_PARAM_INIT_CONTOUR_MIN_PTS) 		nMinPts;
	double 	_id(IDE_REPLICA_PARAM_INIT_CONTOUR_MAX_AREA)		dMaxArea;
	int		_id(IDE_REPLICA_PARAM_INIT_CONTOUR_NUM_Z_LEVELS)    nNumZLevels;
	double	_id(IDE_REPLICA_PARAM_INIT_CONTOUR_MIN_ROUNDNESS)	dMinRoundness;
}ContourFindPeakInfo;

typedef struct tagFindPeakCtrlInfo
{
	DWORD 												dwCtrl;
	int		_id(IDE_REPLICA_PARAM_INIT_DIRECTION)		nDirection;
	int 	_id(IDE_REPLICA_PARAM_INIT_METHOD)			nFindPeakMethod;
	/// Iris 4/13/2009 QA80-13448 CHANGE_LOCAL_POINT_PERCENT_TO_LOCAL_POINTS
	//double 	_id(IDE_REPLICA_PARAM_INIT_LOCAL_POINTS)	dLocalPtsPerc;
	int		_id(IDE_REPLICA_PARAM_INIT_LOCAL_POINTS)	nLocalPts;
	///end CHANGE_LOCAL_POINT_PERCENT_TO_LOCAL_POINTS
	double 	_id(IDE_REPLICA_PARAM_INIT_WIN_HEIGHT)		dWinWidth;
	double 	_id(IDE_REPLICA_PARAM_INIT_WIN_WIDTH)		dWinHeight;
	double 	_id(IDE_REPLICA_PARAM_INIT_MIN_HEIGHT)		dMinPeakHeight;
	ContourFindPeakInfo									cPeakInfo; 								
}FindPeakCtrlInfo;

enum
{
	FIND_2D_PEAK_LOCAL_MAXIMUM = 0,
	FIND_2D_PEAK_1ST_PARTIAL_DERIVATIVE,
	FIND_2D_PEAK_CONTOUR_CONSOLIDATION,
};
///end REPLICA_AUTO_INIT_PARAMS_FOR_SURFACE_FIT

/// Iris 4/23/2008 HIDE_INNER_OUTER_LIMITS_FOR_XYFIT_AND_PA
/**$
	Get fit type, see tagNLFITTYPE in analysis_utils.h.
	Parameters:
		strClassName = [modify] compare strClassName to check fit type.
*/
int		get_fit_type(string& strClassName);
///END HIDE_INNER_OUTER_LIMITS_FOR_XYFIT_AND_PA

//------ Folger 11/06/08 QA80-12538 v0.966 CENTRALIZE_CODE_ABOUT_GETTING_GUI_REPLICA_NODE
/// since NLFitSession & FitterOperation both need to check replica node, so put it here
TreeNode	get_gui_replica_node(const TreeNode& trGUI);
//------

///Sophy 11/21/2008 v8.976 QA80-12591-P3 ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT
int	get_fitted_curve_data_type(const TreeNode& trDataType);
///end ADD_ERRMSG_WHEN_FITCURVE_XDATATYPE_IS_LOG_WITH_NEGATIVE_INPUT

//------ Folger 11/10/08 QA80-12509 v8.0968 ONLY_SET_PLOT_LABEL_TYPE_IN_PEAK_FIT_DIALOG_EXCLUDE_ROTATION
#define		STR_PLOT_DATA_LABEL_TYPE		"tts"
//------

///Jasmine 12/04/08 v8.0982b GET_PLOT_COLUMNS
/**#
	get columns from dataplot
	return 0 if success
	return CER_NO_X_COL if dataplot has no X column
	else return -1
*/
int get_plot_columns(DataPlot dp, Column& colX, Column& colY, Column& colZ = NULL);
///End 

///Kyle 02/24/2009 QA80-13169 CHECK_IF_TWO_RANGE_HAVE_COMMON_RANGE
bool have_common_range(const TreeNode& iy1, const TreeNode& iy2);

bool have_common_range(const XYRange& rng1, const XYRange& rng2);
///End CHECK_IF_TWO_RANGE_HAVE_COMMON_RANGE


///Kyle 02/26/2009 CENTRALIZE_CODE_TO_TRIM_INDEPENDENT
/**$
	for each (x, y, z), if x or y is missing value, this group will be removed.
*/
bool trim_independent(vector& vx, vector& vy, vector& vz);
///End CENTRALIZE_CODE_TO_TRIM_INDEPENDENT


/// Hong 03/09/09 QA80-13243 IMPROVE_AVE_XY_AVOID_MEMORY_LEAKING
/**$
*/
class OneCurveDataMngr
{
public:
	OneCurveDataMngr(int nCount);
	~OneCurveDataMngr();
	
	BOOL			IsValid();
	int				GetCount();
	BOOL			Create(int nIndex, bool bErr, UINT nSize);
	OneCurveData*	GetAt(int nIndex);
	
private:
	BOOL			isValid(OneCurveData* pOCD);
	
private:
	OneCurveData*			m_pData;
	int						m_nCount;
};
/// end IMPROVE_AVE_XY_AVOID_MEMORY_LEAKING

///---Sim 04-02-2009 QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE
/**$
*/
class MultipleVersion
{
public:
	void		AddVersion(LPCSTR lpcszSectionName, double dVersion);
	double		GetVersion(LPCSTR lpcszSectionName);
	
	bool		UpdateTreeAttribute(TreeNode& tr, LPCSTR lpcszAttributeName, bool bToTree = true);
protected:
	vector<string>	m_vsSections;
	vector<double>	m_vVersions;
};
///---END QA80-13403 ADD_INDIVIDUAL_OP_VERSION_FOR_CONVERT_GUI_TREE

///Kyle 06/01/2009 USE_COMMA_AS_DELIMITER_IN_GOS
string check_set_sys_decimal_char(LPCSTR lpcszNumList, LPCSTR lpcszOldDecimalChars);
///End USE_COMMA_AS_DELIMITER_IN_GOS
//----- CPY 7/18/09 QA80-13746 SCV_COL_FX_MENU_SHOW_SN_LN_CLEANUP
///Kyle 07/14/2009 QA80-13746 SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
//string make_colSN_LN_str(LPCSTR lpcszSN, LPCSTR lpcszLN);
//void parse_colSN_LN_str(LPCSTR lpcsz, string* pstrColSN = NULL, string* pstrLN = NULL);
///End SHOWING_BOTH_LN_AND_SN_WITH_STANDARD_NOTATION_IN_THE_MENU_OF_SET_COLUMN_VALUE_DLG
//-----

/**$
*/
///Kyle 12/16/2009 QA80-14832 QUICK_FIT_EDIT_DIALOG_NEED_FUNC_LIST_WITHOUT_ARGUMENT
//int scan_fit_funcs(vector<string>& vsFunctions, LPCSTR lpcszCategory);///---- CPY Kyle 11/04/2009 QA80-14584 SCV_ADD_FITTING_FUNCTIONS
int scan_fit_funcs(vector<string>& vsFunctions, LPCSTR lpcszCategory, BOOL bGetArgList = true);
///End QUICK_FIT_EDIT_DIALOG_NEED_FUNC_LIST_WITHOUT_ARGUMENT

///Kyle 07/20/2009 QA80-13746-P2 SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP, moved from ColMatValues.c
bool is_str_good_for_col_func(LPCSTR lpcsz);
///End SCV_COL_COLUMN_BROWSER_AND_RANGE_BROWSER_SHOW_SN_LN_CLEANUP

///Jasmine 10/19/09 QA81-14478 MASK_DATA_OUSIDE_SD
/**$ 
	Find data that outside N*SD 
	Example:
		//to run this example code, you need have one active worksheet 
		void find_outliers_by_sd_ex(int nCol, int nSD)
		{
			Worksheet wks = Project.ActiveLayer();
			Column cc = wks.Columns(nCol);
		
			vector<uint> vn;
			int nFind = find_outliers_by_sd(cc, nSD, vn);
			if(nFind <= 0)
				return;
			
			//mask the data
			int nColSize = cc.GetUpperBound() + 1;//1 offset
			vector<byte> vMask(nColSize);
			vMask = 0;
			for(int ii = 0; ii < nFind; ii++)
			{
				int nindex = vn[ii];
				vMask[nindex] = 1;
			}
			
		    DatasetObject dsObj(cc);    
		    int nMaskSize = dsObj.SetMask(vMask);
		
		}
	Parameters:
		cc = [input] Column to find data
		nSD = [input] SD factor
		vnIndexes = [output] indexes of data outside nSD*SD
	Return:
	  return number of data outside nSD*SD
*/
int find_outliers_by_sd(const Column& cc, double nSD, vector<uint>& vnIndexes);
///End MASK_DATA_OUSIDE_SD


//--- CPY 11/27/09 QA81-14661-P5 LEVEL_CROSSING_NEED_OPTION_TO_SKIP_NOISY_SPIKES 
///------ Folger 11/30/09 CENTRALIZE_CODE_ABOUT_FIND_ROOTS
//int	find_roots(const vector &vX, const vector &vY, vector &roots, vector<int> &vnDirection = NULL, int nDurationPts = 1, vector<int> &vnXindices = NULL, int nXType = 0);
/// default value of nXType should use 1 (left), it should keep same behavior as pXindex in ocmath_emd_get_zero_crossing,
/// which is used in find_roots in internal.c(commented out now). Since the one has already exists in 81SR0.
/// We should keep the same argument order and default value to make consistence, so that user's code will not be broken.
enum
{
	FIND_ROOTS_INVALID_DURATION_POINTS			= -1000,
	FIND_ROOTS_INVALID_XINDEX,
};
int	find_roots(const vector &vX, const vector &vY, vector &roots, double dBase = 0.0, vector<int> &vnDirection = NULL, int nDurationPts = 1, vector<int> &vnXindices = NULL, int nXType = 1);
///------ End CENTRALIZE_CODE_ABOUT_FIND_ROOTS
//---

///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
void		xf_settings_dumping(TreeNode& trGetN);
///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG

///------ Folger 12/29/09 QA81-14832 SET_GET_QUICK_FIT_SOURCE_PLOT_UID
struct	QuickFitPlotInfo
{
	int		nUID;
	int		nFrom;
	int		nTo;
};
BOOL		quick_fit_source_plot_info_access(QuickFitPlotInfo& stInfo, GraphLayer& gl, BOOL bGet = TRUE);
///------ End SET_GET_QUICK_FIT_SOURCE_PLOT_UID

///------ Folger 01/28/10 SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG
BOOL	get_dataplot_range_description(string& strDescription, const DataPlot& dp, DWORD dwCntrl = 0);
///------ End SHOW_SNAP_TO_DATAPLOT_ON_MAIN_DIALOG

///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT, moved from QuickFit.h
string get_value_by_format(const double dVal, int nDigits, const int nFormat, const int nSubFormat, LPCSTR lpcszCustomFmt = NULL);
string	get_value_by_format(const DataPlot& dp, double dVal, int nDigits = 0);
double	get_value_by_format(const DataPlot& dp, LPCSTR lpcszVal);
///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT

///------ Folger 03/31/10 QA81-15258 XF_GETPTS_NEEDED
BOOL		is_treenode_optional(TreeNode& tr);
BOOL		is_xf_before_execute_body(int nGetNDialog, int dwCntrl);
///------ End XF_GETPTS_NEEDED

///Sophy 4/13/2010 QA81-15308 GET_GRAPHLAYER_OF_INPUTDATA_IN_XF_BODY
bool		get_graphlayer_from_input(const DataRange& iy, GraphLayer& glSrc, int* pnUID = NULL);
///end GET_GRAPHLAYER_OF_INPUTDATA_IN_XF_BODY


/// Fisher 06/29/10 ORG-419	MINTERP2_XF_GOT_BAD_MISSING_VALUE_INTERP_RESULTS
void	get_matrix_xymap(const MatrixObject &im, vector &vx, vector &vy);
/// End MINTERP2_XF_GOT_BAD_MISSING_VALUE_INTERP_RESULTS

///------ Folger 08/02/10 ORG-672 INTEG1_SUPPORT_MULTIPLE_XYRANGES
BOOL		prepare_multixy_output_tree(TreeNode& trInput, TreeNode& trOutput);
///------ End INTEG1_SUPPORT_MULTIPLE_XYRANGES

///------ Folger 08/26/2010 ORG-920-P1 ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA
BOOL	xf_event_is_change_param(TreeNode& trGetN);
///------ End ONE_SAMPLE_TTEST_BETTER_HANDLING_OF_OUTPUT_PLOT_AND_REPORT_DATA

///------ Folger 10/09/2010 ORG-1228-P1 FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL
#define		STR_FITTEROPERATION_CLASS_FITLINEAR			"FitLinear"
#define		STR_FITTEROPERATION_CLASS_FITPOLYNOMIAL		"FitPolynomial"
#define		STR_FITTEROPERATION_CLASS_FITNL				"FitNL"
///------ End FIT_COMPARE_MODEL_EMPTY_FUNCTION_NAME_FOR_LINEAR_AND_POLYNOMIAL

///------ Folger 10/20/2010 ORG-1286-P1 MORE_TOOLS_FAILED_TO_COPY_SAMPLING_INTERVAL_FROM_INPUT
BOOL	xf_copy_vector_sampling_interval(vector& vDest, vector& vSrouce, LPCSTR lpcszOutput);
///------ End MORE_TOOLS_FAILED_TO_COPY_SAMPLING_INTERVAL_FROM_INPUT

#endif //_ANALYSIS_UTILS_H

